/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

public class ConnectorAddressLink {
    private static final String CONNECTOR_ADDRESS_COUNTER = "sun.management.JMXConnectorServer.address";
    private static final String REMOTE_CONNECTOR_COUNTER_PREFIX = "sun.management.JMXConnectorServer.";
    private static AtomicInteger counter = new AtomicInteger();

    public static void export(String address) {
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("address not specified");
        }
        Perf perf = Perf.getPerf();
        perf.createString(CONNECTOR_ADDRESS_COUNTER, 1, Units.STRING.intValue(), address);
    }

    public static String importFrom(int vmid) throws IOException {
        ByteBuffer bb;
        Perf perf = Perf.getPerf();
        try {
            bb = perf.attach(vmid, "r");
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        List<Counter> counters = new PerfInstrumentation(bb).findByPattern(CONNECTOR_ADDRESS_COUNTER);
        Iterator<Counter> i = counters.iterator();
        if (i.hasNext()) {
            Counter c = i.next();
            return (String)c.getValue();
        }
        return null;
    }

    public static void exportRemote(Map<String, String> properties) {
        int index = counter.getAndIncrement();
        Perf perf = Perf.getPerf();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            perf.createString(REMOTE_CONNECTOR_COUNTER_PREFIX + index + "." + entry.getKey(), 1, Units.STRING.intValue(), entry.getValue());
        }
    }

    public static Map<String, String> importRemoteFrom(int vmid) throws IOException {
        ByteBuffer bb;
        Perf perf = Perf.getPerf();
        try {
            bb = perf.attach(vmid, "r");
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        List<Counter> counters = new PerfInstrumentation(bb).getAllCounters();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Counter c : counters) {
            String name = c.getName();
            if (!name.startsWith(REMOTE_CONNECTOR_COUNTER_PREFIX) || name.equals(CONNECTOR_ADDRESS_COUNTER)) continue;
            properties.put(name, c.getValue().toString());
        }
        return properties;
    }
}

