/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Shape;
import java.awt.font.LayoutPath;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Formatter;

public abstract class LayoutPathImpl
extends LayoutPath {
    private static final boolean LOGMAP = false;
    private static final Formatter LOG = new Formatter(System.out);

    public Point2D pointToPath(double x, double y) {
        Point2D.Double pt = new Point2D.Double(x, y);
        this.pointToPath(pt, pt);
        return pt;
    }

    public Point2D pathToPoint(double a, double o, boolean preceding) {
        Point2D.Double pt = new Point2D.Double(a, o);
        this.pathToPoint(pt, preceding, pt);
        return pt;
    }

    public void pointToPath(double x, double y, Point2D pt) {
        pt.setLocation(x, y);
        this.pointToPath(pt, pt);
    }

    public void pathToPoint(double a, double o, boolean preceding, Point2D pt) {
        pt.setLocation(a, o);
        this.pathToPoint(pt, preceding, pt);
    }

    public abstract double start();

    public abstract double end();

    public abstract double length();

    public abstract Shape mapShape(Shape var1);

    public static LayoutPathImpl getPath(EndType etype, double ... coords) {
        if ((coords.length & 1) != 0) {
            throw new IllegalArgumentException("odd number of points not allowed");
        }
        return SegmentPath.get(etype, coords);
    }

    public static class EmptyPath
    extends LayoutPathImpl {
        private AffineTransform tx;

        public EmptyPath(AffineTransform tx) {
            this.tx = tx;
        }

        @Override
        public void pathToPoint(Point2D location, boolean preceding, Point2D point) {
            if (this.tx != null) {
                this.tx.transform(location, point);
            } else {
                point.setLocation(location);
            }
        }

        @Override
        public boolean pointToPath(Point2D pt, Point2D result) {
            result.setLocation(pt);
            if (this.tx != null) {
                try {
                    this.tx.inverseTransform(pt, result);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            return result.getX() > 0.0;
        }

        @Override
        public double start() {
            return 0.0;
        }

        @Override
        public double end() {
            return 0.0;
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public Shape mapShape(Shape s) {
            if (this.tx != null) {
                return this.tx.createTransformedShape(s);
            }
            return s;
        }
    }

    public static final class SegmentPath
    extends LayoutPathImpl {
        private double[] data;
        EndType etype;

        public static SegmentPath get(EndType etype, double ... pts) {
            return new SegmentPathBuilder().build(etype, pts);
        }

        SegmentPath(double[] data, EndType etype) {
            this.data = data;
            this.etype = etype;
        }

        @Override
        public void pathToPoint(Point2D location, boolean preceding, Point2D point) {
            this.locateAndGetIndex(location, preceding, point);
        }

        @Override
        public boolean pointToPath(Point2D pt, Point2D result) {
            boolean doExtend;
            double x = pt.getX();
            double y = pt.getY();
            double bx = this.data[0];
            double by = this.data[1];
            double bl = this.data[2];
            double cd2 = Double.MAX_VALUE;
            double cx = 0.0;
            double cy = 0.0;
            double cl = 0.0;
            int ci = 0;
            for (int i = 3; i < this.data.length; i += 3) {
                double nl;
                double ny;
                double nx;
                block13: {
                    int vi;
                    double vcl;
                    double vcy;
                    double vcx;
                    block11: {
                        block12: {
                            double dot;
                            double dl;
                            double dy;
                            double dx;
                            block10: {
                                nx = this.data[i];
                                ny = this.data[i + 1];
                                nl = this.data[i + 2];
                                dx = nx - bx;
                                dy = ny - by;
                                dl = nl - bl;
                                double px = x - bx;
                                double py = y - by;
                                dot = dx * px + dy * py;
                                if (dl != 0.0 && (!(dot < 0.0) || this.etype.isExtended() && i == 3)) break block10;
                                vcx = bx;
                                vcy = by;
                                vcl = bl;
                                vi = i;
                                break block11;
                            }
                            double l2 = dl * dl;
                            if (!(dot <= l2) && (!this.etype.isExtended() || i != this.data.length - 3)) break block12;
                            double p = dot / l2;
                            vcx = bx + p * dx;
                            vcy = by + p * dy;
                            vcl = bl + p * dl;
                            vi = i;
                            break block11;
                        }
                        if (i != this.data.length - 3) break block13;
                        vcx = nx;
                        vcy = ny;
                        vcl = nl;
                        vi = this.data.length;
                    }
                    double tdx = x - vcx;
                    double tdy = y - vcy;
                    double td2 = tdx * tdx + tdy * tdy;
                    if (td2 <= cd2) {
                        cd2 = td2;
                        cx = vcx;
                        cy = vcy;
                        cl = vcl;
                        ci = vi;
                    }
                }
                bx = nx;
                by = ny;
                bl = nl;
            }
            bx = this.data[ci - 3];
            by = this.data[ci - 2];
            if (cx != bx || cy != by) {
                double nx = this.data[ci];
                double ny = this.data[ci + 1];
                double co = Math.sqrt(cd2);
                if ((x - cx) * (ny - by) > (y - cy) * (nx - bx)) {
                    co = -co;
                }
                result.setLocation(cl, co);
                return false;
            }
            boolean havePrev = ci != 3 && this.data[ci - 1] != this.data[ci - 4];
            boolean haveFoll = ci != this.data.length && this.data[ci - 1] != this.data[ci + 2];
            boolean bl2 = doExtend = this.etype.isExtended() && (ci == 3 || ci == this.data.length);
            if (havePrev && haveFoll) {
                Point2D.Double pp = new Point2D.Double(x, y);
                this.calcoffset(ci - 3, doExtend, pp);
                Point2D.Double fp = new Point2D.Double(x, y);
                this.calcoffset(ci, doExtend, fp);
                if (Math.abs(pp.y) > Math.abs(fp.y)) {
                    result.setLocation(pp);
                    return true;
                }
                result.setLocation(fp);
                return false;
            }
            if (havePrev) {
                result.setLocation(x, y);
                this.calcoffset(ci - 3, doExtend, result);
                return true;
            }
            result.setLocation(x, y);
            this.calcoffset(ci, doExtend, result);
            return false;
        }

        private void calcoffset(int index, boolean doExtend, Point2D result) {
            double bx = this.data[index - 3];
            double by = this.data[index - 2];
            double px = result.getX() - bx;
            double py = result.getY() - by;
            double dx = this.data[index] - bx;
            double dy = this.data[index + 1] - by;
            double l = this.data[index + 2] - this.data[index - 1];
            double rx = (px * dx + py * dy) / l;
            double ry = (px * -dy + py * dx) / l;
            if (!doExtend) {
                if (rx < 0.0) {
                    rx = 0.0;
                } else if (rx > l) {
                    rx = l;
                }
            }
            result.setLocation(rx += this.data[index - 1], ry);
        }

        @Override
        public Shape mapShape(Shape s) {
            return new Mapper().mapShape(s);
        }

        @Override
        public double start() {
            return this.data[2];
        }

        @Override
        public double end() {
            return this.data[this.data.length - 1];
        }

        @Override
        public double length() {
            return this.data[this.data.length - 1] - this.data[2];
        }

        private double getClosedAdvance(double a, boolean preceding) {
            if (this.etype.isClosed()) {
                int count;
                a -= this.data[2];
                if ((a -= (double)(count = (int)(a / this.length())) * this.length()) < 0.0 || a == 0.0 && preceding) {
                    a += this.length();
                }
                a += this.data[2];
            }
            return a;
        }

        private int getSegmentIndexForAdvance(double a, boolean preceding) {
            double v;
            int i;
            a = this.getClosedAdvance(a, preceding);
            int lim = this.data.length - 1;
            for (i = 5; !(i >= lim || a < (v = this.data[i]) || a == v && preceding); i += 3) {
            }
            return i - 2;
        }

        private void map(int seg, double a, double o, Point2D pt) {
            double dx = this.data[seg] - this.data[seg - 3];
            double dy = this.data[seg + 1] - this.data[seg - 2];
            double dl = this.data[seg + 2] - this.data[seg - 1];
            double ux = dx / dl;
            double uy = dy / dl;
            pt.setLocation(this.data[seg - 3] + (a -= this.data[seg - 1]) * ux - o * uy, this.data[seg - 2] + a * uy + o * ux);
        }

        private int locateAndGetIndex(Point2D loc, boolean preceding, Point2D result) {
            double a = loc.getX();
            double o = loc.getY();
            int seg = this.getSegmentIndexForAdvance(a, preceding);
            this.map(seg, a, o, result);
            return seg;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{");
            b.append(this.etype.toString());
            b.append(" ");
            for (int i = 0; i < this.data.length; i += 3) {
                if (i > 0) {
                    b.append(",");
                }
                float x = (float)((int)(this.data[i] * 100.0)) / 100.0f;
                float y = (float)((int)(this.data[i + 1] * 100.0)) / 100.0f;
                float l = (float)((int)(this.data[i + 2] * 10.0)) / 10.0f;
                b.append("{");
                b.append(x);
                b.append(",");
                b.append(y);
                b.append(",");
                b.append(l);
                b.append("}");
            }
            b.append("}");
            return b.toString();
        }

        class Mapper {
            final LineInfo li;
            final ArrayList<Segment> segments;
            final Point2D.Double mpt;
            final Point2D.Double cpt;
            boolean haveMT;

            Mapper() {
                this.li = new LineInfo();
                this.segments = new ArrayList();
                for (int i = 3; i < SegmentPath.this.data.length; i += 3) {
                    if (SegmentPath.this.data[i + 2] == SegmentPath.this.data[i - 1]) continue;
                    this.segments.add(new Segment(i));
                }
                this.mpt = new Point2D.Double();
                this.cpt = new Point2D.Double();
            }

            void init() {
                this.haveMT = false;
                for (Segment s : this.segments) {
                    s.init();
                }
            }

            void moveTo(double x, double y) {
                this.mpt.x = x;
                this.mpt.y = y;
                this.haveMT = true;
            }

            void lineTo(double x, double y) {
                if (this.haveMT) {
                    this.cpt.x = this.mpt.x;
                    this.cpt.y = this.mpt.y;
                }
                if (x == this.cpt.x && y == this.cpt.y) {
                    return;
                }
                if (this.haveMT) {
                    this.haveMT = false;
                    for (Segment s : this.segments) {
                        s.move();
                    }
                }
                this.li.set(this.cpt.x, this.cpt.y, x, y);
                for (Segment s : this.segments) {
                    s.line(this.li);
                }
                this.cpt.x = x;
                this.cpt.y = y;
            }

            void close() {
                this.lineTo(this.mpt.x, this.mpt.y);
                for (Segment s : this.segments) {
                    s.close();
                }
            }

            public Shape mapShape(Shape s) {
                PathIterator pi = s.getPathIterator(null, 1.0);
                this.init();
                double[] coords = new double[2];
                while (!pi.isDone()) {
                    switch (pi.currentSegment(coords)) {
                        case 4: {
                            this.close();
                            break;
                        }
                        case 0: {
                            this.moveTo(coords[0], coords[1]);
                            break;
                        }
                        case 1: {
                            this.lineTo(coords[0], coords[1]);
                            break;
                        }
                    }
                    pi.next();
                }
                GeneralPath gp = new GeneralPath();
                for (Segment seg : this.segments) {
                    gp.append(seg.gp, false);
                }
                return gp;
            }
        }

        class Segment {
            final int ix;
            final double ux;
            final double uy;
            final LineInfo temp;
            boolean broken;
            double cx;
            double cy;
            GeneralPath gp;

            Segment(int ix) {
                this.ix = ix;
                double len = SegmentPath.this.data[ix + 2] - SegmentPath.this.data[ix - 1];
                this.ux = (SegmentPath.this.data[ix] - SegmentPath.this.data[ix - 3]) / len;
                this.uy = (SegmentPath.this.data[ix + 1] - SegmentPath.this.data[ix - 2]) / len;
                this.temp = new LineInfo();
            }

            void init() {
                this.broken = true;
                this.cy = Double.MIN_VALUE;
                this.cx = Double.MIN_VALUE;
                this.gp = new GeneralPath();
            }

            void move() {
                this.broken = true;
            }

            void close() {
                if (!this.broken) {
                    this.gp.closePath();
                }
            }

            void line(LineInfo li) {
                if (li.pin(this.ix, this.temp)) {
                    this.temp.sx -= SegmentPath.this.data[this.ix - 1];
                    double sx = SegmentPath.this.data[this.ix - 3] + this.temp.sx * this.ux - this.temp.sy * this.uy;
                    double sy = SegmentPath.this.data[this.ix - 2] + this.temp.sx * this.uy + this.temp.sy * this.ux;
                    this.temp.lx -= SegmentPath.this.data[this.ix - 1];
                    double lx = SegmentPath.this.data[this.ix - 3] + this.temp.lx * this.ux - this.temp.ly * this.uy;
                    double ly = SegmentPath.this.data[this.ix - 2] + this.temp.lx * this.uy + this.temp.ly * this.ux;
                    if (sx != this.cx || sy != this.cy) {
                        if (this.broken) {
                            this.gp.moveTo((float)sx, (float)sy);
                        } else {
                            this.gp.lineTo((float)sx, (float)sy);
                        }
                    }
                    this.gp.lineTo((float)lx, (float)ly);
                    this.broken = false;
                    this.cx = lx;
                    this.cy = ly;
                }
            }
        }

        class LineInfo {
            double sx;
            double sy;
            double lx;
            double ly;
            double m;

            LineInfo() {
            }

            void set(double sx, double sy, double lx, double ly) {
                this.sx = sx;
                this.sy = sy;
                this.lx = lx;
                this.ly = ly;
                double dx = lx - sx;
                if (dx == 0.0) {
                    this.m = 0.0;
                } else {
                    double dy = ly - sy;
                    this.m = dy / dx;
                }
            }

            void set(LineInfo rhs) {
                this.sx = rhs.sx;
                this.sy = rhs.sy;
                this.lx = rhs.lx;
                this.ly = rhs.ly;
                this.m = rhs.m;
            }

            boolean pin(double lo, double hi, LineInfo result) {
                result.set(this);
                if (this.lx >= this.sx) {
                    if (this.sx < hi && this.lx >= lo) {
                        if (this.sx < lo) {
                            if (this.m != 0.0) {
                                result.sy = this.sy + this.m * (lo - this.sx);
                            }
                            result.sx = lo;
                        }
                        if (this.lx > hi) {
                            if (this.m != 0.0) {
                                result.ly = this.ly + this.m * (hi - this.lx);
                            }
                            result.lx = hi;
                        }
                        return true;
                    }
                } else if (this.lx < hi && this.sx >= lo) {
                    if (this.lx < lo) {
                        if (this.m != 0.0) {
                            result.ly = this.ly + this.m * (lo - this.lx);
                        }
                        result.lx = lo;
                    }
                    if (this.sx > hi) {
                        if (this.m != 0.0) {
                            result.sy = this.sy + this.m * (hi - this.sx);
                        }
                        result.sx = hi;
                    }
                    return true;
                }
                return false;
            }

            boolean pin(int ix, LineInfo result) {
                double lo = SegmentPath.this.data[ix - 1];
                double hi = SegmentPath.this.data[ix + 2];
                switch (SegmentPath.this.etype) {
                    case PINNED: {
                        break;
                    }
                    case EXTENDED: {
                        if (ix == 3) {
                            lo = Double.NEGATIVE_INFINITY;
                        }
                        if (ix != SegmentPath.this.data.length - 3) break;
                        hi = Double.POSITIVE_INFINITY;
                        break;
                    }
                }
                return this.pin(lo, hi, result);
            }
        }
    }

    public static final class SegmentPathBuilder {
        private double[] data;
        private int w;
        private double px;
        private double py;
        private double a;
        private boolean pconnect;

        public void reset(int datalen) {
            if (this.data == null || datalen > this.data.length) {
                this.data = new double[datalen];
            } else if (datalen == 0) {
                this.data = null;
            }
            this.w = 0;
            this.py = 0.0;
            this.px = 0.0;
            this.pconnect = false;
        }

        public SegmentPath build(EndType etype, double ... pts) {
            assert (pts.length % 2 == 0);
            this.reset(pts.length / 2 * 3);
            for (int i = 0; i < pts.length; i += 2) {
                this.nextPoint(pts[i], pts[i + 1], i != 0);
            }
            return this.complete(etype);
        }

        public void moveTo(double x, double y) {
            this.nextPoint(x, y, false);
        }

        public void lineTo(double x, double y) {
            this.nextPoint(x, y, true);
        }

        private void nextPoint(double x, double y, boolean connect) {
            if (x == this.px && y == this.py) {
                return;
            }
            if (this.w == 0) {
                if (this.data == null) {
                    this.data = new double[6];
                }
                if (connect) {
                    this.w = 3;
                }
            }
            if (this.w != 0 && !connect && !this.pconnect) {
                this.data[this.w - 3] = this.px = x;
                this.data[this.w - 2] = this.py = y;
                return;
            }
            if (this.w == this.data.length) {
                double[] t = new double[this.w * 2];
                System.arraycopy(this.data, 0, t, 0, this.w);
                this.data = t;
            }
            if (connect) {
                double dx = x - this.px;
                double dy = y - this.py;
                this.a += Math.sqrt(dx * dx + dy * dy);
            }
            this.data[this.w++] = x;
            this.data[this.w++] = y;
            this.data[this.w++] = this.a;
            this.px = x;
            this.py = y;
            this.pconnect = connect;
        }

        public SegmentPath complete() {
            return this.complete(EndType.EXTENDED);
        }

        public SegmentPath complete(EndType etype) {
            SegmentPath result;
            if (this.data == null || this.w < 6) {
                return null;
            }
            if (this.w == this.data.length) {
                result = new SegmentPath(this.data, etype);
                this.reset(0);
            } else {
                double[] dataToAdopt = new double[this.w];
                System.arraycopy(this.data, 0, dataToAdopt, 0, this.w);
                result = new SegmentPath(dataToAdopt, etype);
                this.reset(2);
            }
            return result;
        }
    }

    public static enum EndType {
        PINNED,
        EXTENDED,
        CLOSED;


        public boolean isPinned() {
            return this == PINNED;
        }

        public boolean isExtended() {
            return this == EXTENDED;
        }

        public boolean isClosed() {
            return this == CLOSED;
        }
    }
}

