/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import sun.nio.ch.DevPollSelectorProvider;
import sun.nio.ch.EPollSelectorProvider;
import sun.nio.ch.PollSelectorProvider;
import sun.security.action.GetPropertyAction;

public class DefaultSelectorProvider {
    private DefaultSelectorProvider() {
    }

    public static SelectorProvider create() {
        String osversion;
        String[] vers;
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if ("SunOS".equals(osname)) {
            return new DevPollSelectorProvider();
        }
        if ("Linux".equals(osname) && (vers = (osversion = AccessController.doPrivileged(new GetPropertyAction("os.version"))).split("\\.", 0)).length >= 2) {
            try {
                int major = Integer.parseInt(vers[0]);
                int minor = Integer.parseInt(vers[1]);
                if (major > 2 || major == 2 && minor >= 6) {
                    return new EPollSelectorProvider();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new PollSelectorProvider();
    }
}

