/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class ScreenFormat
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 24;
    }

    @Override
    public int getDataSize() {
        return ScreenFormat.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public ScreenFormat(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public ScreenFormat() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(ScreenFormat.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(index * 32)) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_depth(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public int get_bits_per_pixel() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_bits_per_pixel(int v) {
        log.finest("");
        Native.putInt(this.pData + 12L, v);
    }

    public int get_scanline_pad() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_scanline_pad(int v) {
        log.finest("");
        Native.putInt(this.pData + 16L, v);
    }

    @Override
    String getName() {
        return "ScreenFormat";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(160);
        ret.append("ext_data = ").append(this.get_ext_data()).append(", ");
        ret.append("depth = ").append(this.get_depth()).append(", ");
        ret.append("bits_per_pixel = ").append(this.get_bits_per_pixel()).append(", ");
        ret.append("scanline_pad = ").append(this.get_scanline_pad()).append(", ");
        return ret.toString();
    }
}

