/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileKey;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;

class UnixFileAttributes
implements PosixFileAttributes {
    private int st_mode;
    private long st_ino;
    private long st_dev;
    private long st_rdev;
    private int st_nlink;
    private int st_uid;
    private int st_gid;
    private long st_size;
    private long st_atime;
    private long st_mtime;
    private long st_ctime;
    private volatile UserPrincipal owner;
    private volatile GroupPrincipal group;
    private volatile UnixFileKey key;

    private UnixFileAttributes() {
    }

    static UnixFileAttributes get(UnixPath path, boolean followLinks) throws UnixException {
        UnixFileAttributes attrs = new UnixFileAttributes();
        if (followLinks) {
            UnixNativeDispatcher.stat(path, attrs);
        } else {
            UnixNativeDispatcher.lstat(path, attrs);
        }
        return attrs;
    }

    static UnixFileAttributes get(int fd) throws UnixException {
        UnixFileAttributes attrs = new UnixFileAttributes();
        UnixNativeDispatcher.fstat(fd, attrs);
        return attrs;
    }

    static UnixFileAttributes get(int dfd, UnixPath path, boolean followLinks) throws UnixException {
        UnixFileAttributes attrs = new UnixFileAttributes();
        int flag = followLinks ? 0 : 256;
        UnixNativeDispatcher.fstatat(dfd, path.asByteArray(), flag, attrs);
        return attrs;
    }

    boolean isSameFile(UnixFileAttributes attrs) {
        return this.st_ino == attrs.st_ino && this.st_dev == attrs.st_dev;
    }

    int mode() {
        return this.st_mode;
    }

    long ino() {
        return this.st_ino;
    }

    long dev() {
        return this.st_dev;
    }

    long rdev() {
        return this.st_rdev;
    }

    int nlink() {
        return this.st_nlink;
    }

    int uid() {
        return this.st_uid;
    }

    int gid() {
        return this.st_gid;
    }

    FileTime ctime() {
        return FileTime.from(this.st_ctime, TimeUnit.SECONDS);
    }

    boolean isDevice() {
        int type = this.st_mode & 0xF000;
        return type == 8192 || type == 24576 || type == 4096;
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.from(this.st_mtime, TimeUnit.SECONDS);
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.from(this.st_atime, TimeUnit.SECONDS);
    }

    @Override
    public FileTime creationTime() {
        return this.lastModifiedTime();
    }

    @Override
    public boolean isRegularFile() {
        return (this.st_mode & 0xF000) == 32768;
    }

    @Override
    public boolean isDirectory() {
        return (this.st_mode & 0xF000) == 16384;
    }

    @Override
    public boolean isSymbolicLink() {
        return (this.st_mode & 0xF000) == 40960;
    }

    @Override
    public boolean isOther() {
        int type = this.st_mode & 0xF000;
        return type != 32768 && type != 16384 && type != 40960;
    }

    @Override
    public long size() {
        return this.st_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnixFileKey fileKey() {
        if (this.key == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.key == null) {
                    this.key = new UnixFileKey(this.st_dev, this.st_ino);
                }
            }
        }
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal owner() {
        if (this.owner == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.owner == null) {
                    this.owner = UnixUserPrincipals.fromUid(this.st_uid);
                }
            }
        }
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupPrincipal group() {
        if (this.group == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.group == null) {
                    this.group = UnixUserPrincipals.fromGid(this.st_gid);
                }
            }
        }
        return this.group;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        int bits = this.st_mode & 0x1FF;
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((bits & 0x100) > 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((bits & 0x80) > 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((bits & 0x40) > 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((bits & 0x20) > 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((bits & 0x10) > 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((bits & 8) > 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((bits & 4) > 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((bits & 2) > 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((bits & 1) > 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    BasicFileAttributes asBasicFileAttributes() {
        return UnixAsBasicFileAttributes.wrap(this);
    }

    static UnixFileAttributes toUnixFileAttributes(BasicFileAttributes attrs) {
        if (attrs instanceof UnixFileAttributes) {
            return (UnixFileAttributes)attrs;
        }
        if (attrs instanceof UnixAsBasicFileAttributes) {
            return ((UnixAsBasicFileAttributes)attrs).unwrap();
        }
        return null;
    }

    private static class UnixAsBasicFileAttributes
    implements BasicFileAttributes {
        private final UnixFileAttributes attrs;

        private UnixAsBasicFileAttributes(UnixFileAttributes attrs) {
            this.attrs = attrs;
        }

        static UnixAsBasicFileAttributes wrap(UnixFileAttributes attrs) {
            return new UnixAsBasicFileAttributes(attrs);
        }

        UnixFileAttributes unwrap() {
            return this.attrs;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.attrs.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return this.attrs.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return this.attrs.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.attrs.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return this.attrs.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.attrs.isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return this.attrs.isOther();
        }

        @Override
        public long size() {
            return this.attrs.size();
        }

        @Override
        public Object fileKey() {
            return this.attrs.fileKey();
        }
    }
}

