/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import sun.management.GcInfoCompositeData;
import sun.management.Util;

public class GcInfoBuilder {
    private final GarbageCollectorMXBean gc;
    private final String[] poolNames;
    private String[] allItemNames;
    private CompositeType gcInfoCompositeType;
    private final int gcExtItemCount;
    private final String[] gcExtItemNames;
    private final String[] gcExtItemDescs;
    private final char[] gcExtItemTypes;

    GcInfoBuilder(GarbageCollectorMXBean gc, String[] poolNames) {
        this.gc = gc;
        this.poolNames = poolNames;
        this.gcExtItemCount = this.getNumGcExtAttributes(gc);
        this.gcExtItemNames = new String[this.gcExtItemCount];
        this.gcExtItemDescs = new String[this.gcExtItemCount];
        this.gcExtItemTypes = new char[this.gcExtItemCount];
        this.fillGcAttributeInfo(gc, this.gcExtItemCount, this.gcExtItemNames, this.gcExtItemTypes, this.gcExtItemDescs);
        this.gcInfoCompositeType = null;
    }

    GcInfo getLastGcInfo() {
        MemoryUsage[] usageBeforeGC = new MemoryUsage[this.poolNames.length];
        MemoryUsage[] usageAfterGC = new MemoryUsage[this.poolNames.length];
        Object[] values = new Object[this.gcExtItemCount];
        return this.getLastGcInfo0(this.gc, this.gcExtItemCount, values, this.gcExtItemTypes, usageBeforeGC, usageAfterGC);
    }

    public String[] getPoolNames() {
        return this.poolNames;
    }

    int getGcExtItemCount() {
        return this.gcExtItemCount;
    }

    synchronized CompositeType getGcInfoCompositeType() {
        if (this.gcInfoCompositeType != null) {
            return this.gcInfoCompositeType;
        }
        String[] gcInfoItemNames = GcInfoCompositeData.getBaseGcInfoItemNames();
        OpenType[] gcInfoItemTypes = GcInfoCompositeData.getBaseGcInfoItemTypes();
        int numGcInfoItems = gcInfoItemNames.length;
        int itemCount = numGcInfoItems + this.gcExtItemCount;
        this.allItemNames = new String[itemCount];
        String[] allItemDescs = new String[itemCount];
        OpenType[] allItemTypes = new OpenType[itemCount];
        System.arraycopy(gcInfoItemNames, 0, this.allItemNames, 0, numGcInfoItems);
        System.arraycopy(gcInfoItemNames, 0, allItemDescs, 0, numGcInfoItems);
        System.arraycopy(gcInfoItemTypes, 0, allItemTypes, 0, numGcInfoItems);
        if (this.gcExtItemCount > 0) {
            this.fillGcAttributeInfo(this.gc, this.gcExtItemCount, this.gcExtItemNames, this.gcExtItemTypes, this.gcExtItemDescs);
            System.arraycopy(this.gcExtItemNames, 0, this.allItemNames, numGcInfoItems, this.gcExtItemCount);
            System.arraycopy(this.gcExtItemDescs, 0, allItemDescs, numGcInfoItems, this.gcExtItemCount);
            int i = numGcInfoItems;
            for (int j = 0; j < this.gcExtItemCount; ++j) {
                switch (this.gcExtItemTypes[j]) {
                    case 'Z': {
                        allItemTypes[i] = SimpleType.BOOLEAN;
                        break;
                    }
                    case 'B': {
                        allItemTypes[i] = SimpleType.BYTE;
                        break;
                    }
                    case 'C': {
                        allItemTypes[i] = SimpleType.CHARACTER;
                        break;
                    }
                    case 'S': {
                        allItemTypes[i] = SimpleType.SHORT;
                        break;
                    }
                    case 'I': {
                        allItemTypes[i] = SimpleType.INTEGER;
                        break;
                    }
                    case 'J': {
                        allItemTypes[i] = SimpleType.LONG;
                        break;
                    }
                    case 'F': {
                        allItemTypes[i] = SimpleType.FLOAT;
                        break;
                    }
                    case 'D': {
                        allItemTypes[i] = SimpleType.DOUBLE;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported type [" + this.gcExtItemTypes[i] + "]"));
                    }
                }
                ++i;
            }
        }
        CompositeType gict = null;
        try {
            String typeName = "sun.management." + this.gc.getName() + ".GcInfoCompositeType";
            gict = new CompositeType(typeName, "CompositeType for GC info for " + this.gc.getName(), this.allItemNames, allItemDescs, allItemTypes);
        }
        catch (OpenDataException e) {
            throw Util.newException(e);
        }
        this.gcInfoCompositeType = gict;
        return this.gcInfoCompositeType;
    }

    synchronized String[] getItemNames() {
        if (this.allItemNames == null) {
            this.getGcInfoCompositeType();
        }
        return this.allItemNames;
    }

    private native int getNumGcExtAttributes(GarbageCollectorMXBean var1);

    private native void fillGcAttributeInfo(GarbageCollectorMXBean var1, int var2, String[] var3, char[] var4, String[] var5);

    private native GcInfo getLastGcInfo0(GarbageCollectorMXBean var1, int var2, Object[] var3, char[] var4, MemoryUsage[] var5, MemoryUsage[] var6);
}

