/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class CancelReservedInstancesListing
extends BaseCmd {
    public CancelReservedInstancesListing(String[] args) {
        super("ec2caril", "ec2-cancel-reserved-instances-listing");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "LISTING";
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("    Cancels the specified Reserved Instance listing in the");
        System.out.println("    Reserved Instance Marketplace.");
    }

    @Override
    public void printOptions() {
        super.printOptions(false);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        this.assertNonOptionSet("LISTING");
        RequestResultPair rsp = jec2.cancelReservedInstancesListing(this.getNonOptions()[0]);
        out.outputReservedInstancesListings(System.out, (List)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new CancelReservedInstancesListing(args).invoke();
    }
}

