/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class DesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private static final ReferenceQueue<DesktopProperty> queue;
    private WeakPCL pcl;
    private final String key;
    private Object value;
    private final Object fallback;

    static void flushUnreferencedProperties() {
        WeakPCL pcl;
        while ((pcl = (WeakPCL)queue.poll()) != null) {
            pcl.dispose();
        }
    }

    private static synchronized void setUpdatePending(boolean update) {
        updatePending = update;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] appFrames;
        Class<?> uiClass = UIManager.getLookAndFeel().getClass();
        if (uiClass.getPackage().equals(DesktopProperty.class.getPackage())) {
            XPStyle.invalidateStyle();
        }
        for (Frame appFrame : appFrames = Frame.getFrames()) {
            DesktopProperty.updateWindowUI(appFrame);
        }
    }

    private static void updateWindowUI(Window window) {
        Window[] ownedWins;
        SwingUtilities.updateComponentTreeUI(window);
        for (Window ownedWin : ownedWins = window.getOwnedWindows()) {
            DesktopProperty.updateWindowUI(ownedWin);
        }
    }

    public DesktopProperty(String key, Object fallback) {
        this.key = key;
        this.fallback = fallback;
        DesktopProperty.flushUnreferencedProperties();
    }

    @Override
    public Object createValue(UIDefaults table) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected Object getValueFromDesktop() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (this.pcl == null) {
            this.pcl = new WeakPCL(this, this.getKey(), UIManager.getLookAndFeel());
            toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        }
        return toolkit.getDesktopProperty(this.getKey());
    }

    protected Object getDefaultValue() {
        return this.fallback;
    }

    public void invalidate(LookAndFeel laf) {
        this.invalidate();
    }

    public void invalidate() {
        this.value = null;
    }

    protected void updateUI() {
        if (!DesktopProperty.isUpdatePending()) {
            DesktopProperty.setUpdatePending(true);
            Runnable uiUpdater = new Runnable(){

                @Override
                public void run() {
                    DesktopProperty.updateAllUIs();
                    DesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(uiUpdater);
        }
    }

    protected Object configureValue(Object value) {
        if (value != null) {
            if (value instanceof Color) {
                return new ColorUIResource((Color)value);
            }
            if (value instanceof Font) {
                return new FontUIResource((Font)value);
            }
            if (value instanceof UIDefaults.LazyValue) {
                value = ((UIDefaults.LazyValue)value).createValue(null);
            } else if (value instanceof UIDefaults.ActiveValue) {
                value = ((UIDefaults.ActiveValue)value).createValue(null);
            }
        }
        return value;
    }

    protected String getKey() {
        return this.key;
    }

    static {
        queue = new ReferenceQueue();
    }

    private static class WeakPCL
    extends WeakReference<DesktopProperty>
    implements PropertyChangeListener {
        private String key;
        private LookAndFeel laf;

        WeakPCL(DesktopProperty target, String key, LookAndFeel laf) {
            super(target, queue);
            this.key = key;
            this.laf = laf;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            DesktopProperty property = (DesktopProperty)this.get();
            if (property == null || this.laf != UIManager.getLookAndFeel()) {
                this.dispose();
            } else {
                property.invalidate(this.laf);
                property.updateUI();
            }
        }

        void dispose() {
            Toolkit.getDefaultToolkit().removePropertyChangeListener(this.key, this);
        }
    }
}

