/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.LinkedList;
import java.util.ListIterator;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.rcache.AuthTime;
import sun.security.krb5.internal.rcache.CacheTable;

public class ReplayCache
extends LinkedList<AuthTime> {
    private static final long serialVersionUID = 2997933194993803994L;
    private String principal;
    private CacheTable table;
    private int nap = 600000;
    private boolean DEBUG = Krb5.DEBUG;

    public ReplayCache(String p, CacheTable ct) {
        this.principal = p;
        this.table = ct;
    }

    public synchronized void put(AuthTime t, long currentTime) {
        block7: {
            AuthTime temp;
            block9: {
                block8: {
                    block6: {
                        if (this.size() != 0) break block6;
                        this.addFirst(t);
                        break block7;
                    }
                    temp = (AuthTime)this.getFirst();
                    if (temp.kerberosTime >= t.kerberosTime) break block8;
                    this.addFirst(t);
                    break block7;
                }
                if (temp.kerberosTime != t.kerberosTime) break block9;
                if (temp.cusec >= t.cusec) break block7;
                this.addFirst(t);
                break block7;
            }
            ListIterator it = this.listIterator(1);
            while (it.hasNext()) {
                temp = (AuthTime)it.next();
                if (temp.kerberosTime < t.kerberosTime) {
                    this.add(this.indexOf(temp), t);
                    break;
                }
                if (temp.kerberosTime != t.kerberosTime || temp.cusec >= t.cusec) continue;
                this.add(this.indexOf(temp), t);
                break;
            }
        }
        long timeLimit = currentTime - (long)KerberosTime.getDefaultSkew() * 1000L;
        ListIterator it = this.listIterator(0);
        AuthTime temp = null;
        int index = -1;
        while (it.hasNext()) {
            temp = (AuthTime)it.next();
            if (temp.kerberosTime >= timeLimit) continue;
            index = this.indexOf(temp);
            break;
        }
        if (index > -1) {
            do {
                this.removeLast();
            } while (this.size() > index);
        }
        if (this.DEBUG) {
            this.printList();
        }
    }

    private void printList() {
        Object[] total = this.toArray();
        for (int i = 0; i < total.length; ++i) {
            System.out.println("object " + i + ": " + ((AuthTime)total[i]).kerberosTime + "/" + ((AuthTime)total[i]).cusec);
        }
    }
}

