/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteSnapshot
extends BaseCmd {
    public DeleteSnapshot(String[] args) {
        super("ec2delsnap", "ec2-delete-snapshot");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    protected String getOptionString() {
        return "SNAPSHOT";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete a previously created snapshot.");
        System.out.println("     The SNAPSHOT parameter identifies the completed snapshot to be deleted.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("SNAPSHOT");
        String snapshotId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        RequestResultPair rsp = jec2.deleteSnapshot(snapshotId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputSnapshot(System.out, snapshotId);
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DeleteSnapshot(args).invoke();
    }
}

