/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.CharArrayIterator;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;

public final class LineBreakMeasurer {
    private BreakIterator breakIter;
    private int start;
    private int pos;
    private int limit;
    private TextMeasurer measurer;
    private CharArrayIterator charIter;

    public LineBreakMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this(text, BreakIterator.getLineInstance(), frc);
    }

    public LineBreakMeasurer(AttributedCharacterIterator text, BreakIterator breakIter, FontRenderContext frc) {
        if (text.getEndIndex() - text.getBeginIndex() < 1) {
            throw new IllegalArgumentException("Text must contain at least one character.");
        }
        this.breakIter = breakIter;
        this.measurer = new TextMeasurer(text, frc);
        this.limit = text.getEndIndex();
        this.pos = this.start = text.getBeginIndex();
        this.charIter = new CharArrayIterator(this.measurer.getChars(), this.start);
        this.breakIter.setText(this.charIter);
    }

    public int nextOffset(float wrappingWidth) {
        return this.nextOffset(wrappingWidth, this.limit, false);
    }

    public int nextOffset(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        int nextOffset = this.pos;
        if (this.pos < this.limit) {
            if (offsetLimit <= this.pos) {
                throw new IllegalArgumentException("offsetLimit must be after current position");
            }
            int charAtMaxAdvance = this.measurer.getLineBreakIndex(this.pos, wrappingWidth);
            if (charAtMaxAdvance == this.limit) {
                nextOffset = this.limit;
            } else if (Character.isWhitespace(this.measurer.getChars()[charAtMaxAdvance - this.start])) {
                nextOffset = this.breakIter.following(charAtMaxAdvance);
            } else {
                int testPos = charAtMaxAdvance + 1;
                if (testPos == this.limit) {
                    this.breakIter.last();
                    nextOffset = this.breakIter.previous();
                } else {
                    nextOffset = this.breakIter.preceding(testPos);
                }
                if (nextOffset <= this.pos) {
                    nextOffset = requireNextWord ? this.pos : Math.max(this.pos + 1, charAtMaxAdvance);
                }
            }
        }
        if (nextOffset > offsetLimit) {
            nextOffset = offsetLimit;
        }
        return nextOffset;
    }

    public TextLayout nextLayout(float wrappingWidth) {
        return this.nextLayout(wrappingWidth, this.limit, false);
    }

    public TextLayout nextLayout(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        if (this.pos < this.limit) {
            int layoutLimit = this.nextOffset(wrappingWidth, offsetLimit, requireNextWord);
            if (layoutLimit == this.pos) {
                return null;
            }
            TextLayout result = this.measurer.getLayout(this.pos, layoutLimit);
            this.pos = layoutLimit;
            return result;
        }
        return null;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int newPosition) {
        if (newPosition < this.start || newPosition > this.limit) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.pos = newPosition;
    }

    public void insertChar(AttributedCharacterIterator newParagraph, int insertPos) {
        this.measurer.insertChar(newParagraph, insertPos);
        this.limit = newParagraph.getEndIndex();
        this.pos = this.start = newParagraph.getBeginIndex();
        this.charIter.reset(this.measurer.getChars(), newParagraph.getBeginIndex());
        this.breakIter.setText(this.charIter);
    }

    public void deleteChar(AttributedCharacterIterator newParagraph, int deletePos) {
        this.measurer.deleteChar(newParagraph, deletePos);
        this.limit = newParagraph.getEndIndex();
        this.pos = this.start = newParagraph.getBeginIndex();
        this.charIter.reset(this.measurer.getChars(), this.start);
        this.breakIter.setText(this.charIter);
    }
}

