/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.Serializable;
import sun.java2d.cmm.CMSManager;

public abstract class ColorSpace
implements Serializable {
    static final long serialVersionUID = -409452704308689724L;
    private int type;
    private int numComponents;
    private transient String[] compName = null;
    private static ColorSpace sRGBspace;
    private static ColorSpace XYZspace;
    private static ColorSpace PYCCspace;
    private static ColorSpace GRAYspace;
    private static ColorSpace LINEAR_RGBspace;
    public static final int TYPE_XYZ = 0;
    public static final int TYPE_Lab = 1;
    public static final int TYPE_Luv = 2;
    public static final int TYPE_YCbCr = 3;
    public static final int TYPE_Yxy = 4;
    public static final int TYPE_RGB = 5;
    public static final int TYPE_GRAY = 6;
    public static final int TYPE_HSV = 7;
    public static final int TYPE_HLS = 8;
    public static final int TYPE_CMYK = 9;
    public static final int TYPE_CMY = 11;
    public static final int TYPE_2CLR = 12;
    public static final int TYPE_3CLR = 13;
    public static final int TYPE_4CLR = 14;
    public static final int TYPE_5CLR = 15;
    public static final int TYPE_6CLR = 16;
    public static final int TYPE_7CLR = 17;
    public static final int TYPE_8CLR = 18;
    public static final int TYPE_9CLR = 19;
    public static final int TYPE_ACLR = 20;
    public static final int TYPE_BCLR = 21;
    public static final int TYPE_CCLR = 22;
    public static final int TYPE_DCLR = 23;
    public static final int TYPE_ECLR = 24;
    public static final int TYPE_FCLR = 25;
    public static final int CS_sRGB = 1000;
    public static final int CS_LINEAR_RGB = 1004;
    public static final int CS_CIEXYZ = 1001;
    public static final int CS_PYCC = 1002;
    public static final int CS_GRAY = 1003;

    protected ColorSpace(int type, int numcomponents) {
        this.type = type;
        this.numComponents = numcomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorSpace getInstance(int colorspace) {
        switch (colorspace) {
            case 1000: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (sRGBspace != null) return sRGBspace;
                    ICC_Profile theProfile = ICC_Profile.getInstance(1000);
                    sRGBspace = new ICC_ColorSpace(theProfile);
                    return sRGBspace;
                }
            }
            case 1001: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (XYZspace != null) return XYZspace;
                    ICC_Profile theProfile = ICC_Profile.getInstance(1001);
                    XYZspace = new ICC_ColorSpace(theProfile);
                    return XYZspace;
                }
            }
            case 1002: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (PYCCspace != null) return PYCCspace;
                    ICC_Profile theProfile = ICC_Profile.getInstance(1002);
                    PYCCspace = new ICC_ColorSpace(theProfile);
                    return PYCCspace;
                }
            }
            case 1003: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (GRAYspace != null) return GRAYspace;
                    ICC_Profile theProfile = ICC_Profile.getInstance(1003);
                    CMSManager.GRAYspace = GRAYspace = new ICC_ColorSpace(theProfile);
                    return GRAYspace;
                }
            }
            case 1004: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (LINEAR_RGBspace != null) return LINEAR_RGBspace;
                    ICC_Profile theProfile = ICC_Profile.getInstance(1004);
                    CMSManager.LINEAR_RGBspace = LINEAR_RGBspace = new ICC_ColorSpace(theProfile);
                    return LINEAR_RGBspace;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown color space");
            }
        }
    }

    public boolean isCS_sRGB() {
        return this == sRGBspace;
    }

    public abstract float[] toRGB(float[] var1);

    public abstract float[] fromRGB(float[] var1);

    public abstract float[] toCIEXYZ(float[] var1);

    public abstract float[] fromCIEXYZ(float[] var1);

    public int getType() {
        return this.type;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getName(int idx) {
        if (idx < 0 || idx > this.numComponents - 1) {
            throw new IllegalArgumentException("Component index out of range: " + idx);
        }
        if (this.compName == null) {
            switch (this.type) {
                case 0: {
                    this.compName = new String[]{"X", "Y", "Z"};
                    break;
                }
                case 1: {
                    this.compName = new String[]{"L", "a", "b"};
                    break;
                }
                case 2: {
                    this.compName = new String[]{"L", "u", "v"};
                    break;
                }
                case 3: {
                    this.compName = new String[]{"Y", "Cb", "Cr"};
                    break;
                }
                case 4: {
                    this.compName = new String[]{"Y", "x", "y"};
                    break;
                }
                case 5: {
                    this.compName = new String[]{"Red", "Green", "Blue"};
                    break;
                }
                case 6: {
                    this.compName = new String[]{"Gray"};
                    break;
                }
                case 7: {
                    this.compName = new String[]{"Hue", "Saturation", "Value"};
                    break;
                }
                case 8: {
                    this.compName = new String[]{"Hue", "Lightness", "Saturation"};
                    break;
                }
                case 9: {
                    this.compName = new String[]{"Cyan", "Magenta", "Yellow", "Black"};
                    break;
                }
                case 11: {
                    this.compName = new String[]{"Cyan", "Magenta", "Yellow"};
                    break;
                }
                default: {
                    String[] tmp = new String[this.numComponents];
                    for (int i = 0; i < tmp.length; ++i) {
                        tmp[i] = "Unnamed color component(" + i + ")";
                    }
                    this.compName = tmp;
                }
            }
        }
        return this.compName[idx];
    }

    public float getMinValue(int component) {
        if (component < 0 || component > this.numComponents - 1) {
            throw new IllegalArgumentException("Component index out of range: " + component);
        }
        return 0.0f;
    }

    public float getMaxValue(int component) {
        if (component < 0 || component > this.numComponents - 1) {
            throw new IllegalArgumentException("Component index out of range: " + component);
        }
        return 1.0f;
    }

    static boolean isCS_CIEXYZ(ColorSpace cspace) {
        return cspace == XYZspace;
    }
}

