/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.InternationalFormatter;

public class DateFormatter
extends InternationalFormatter {
    public DateFormatter() {
        this(DateFormat.getDateInstance());
    }

    public DateFormatter(DateFormat format) {
        super(format);
        this.setFormat(format);
    }

    public void setFormat(DateFormat format) {
        super.setFormat(format);
    }

    private Calendar getCalendar() {
        Format f = this.getFormat();
        if (f instanceof DateFormat) {
            return ((DateFormat)f).getCalendar();
        }
        return Calendar.getInstance();
    }

    @Override
    boolean getSupportsIncrement() {
        return true;
    }

    @Override
    Object getAdjustField(int start, Map attributes) {
        for (Object key : attributes.keySet()) {
            if (!(key instanceof DateFormat.Field) || key != DateFormat.Field.HOUR1 && ((DateFormat.Field)key).getCalendarField() == -1) continue;
            return key;
        }
        return null;
    }

    @Override
    Object adjustValue(Object value, Map attributes, Object key, int direction) throws BadLocationException, ParseException {
        if (key != null) {
            if (key == DateFormat.Field.HOUR1) {
                key = DateFormat.Field.HOUR0;
            }
            int field = ((DateFormat.Field)key).getCalendarField();
            Calendar calendar = this.getCalendar();
            if (calendar != null) {
                calendar.setTime((Date)value);
                int fieldValue = calendar.get(field);
                try {
                    calendar.add(field, direction);
                    value = calendar.getTime();
                }
                catch (Throwable th) {
                    value = null;
                }
                return value;
            }
        }
        return null;
    }
}

