/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.List;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.ToolkitImage;
import sun.misc.SoftCache;

public class MultiResolutionToolkitImage
extends ToolkitImage
implements MultiResolutionImage {
    Image resolutionVariant;
    private static final int BITS_INFO = 56;

    public MultiResolutionToolkitImage(Image lowResolutionImage, Image resolutionVariant) {
        super(lowResolutionImage.getSource());
        this.resolutionVariant = resolutionVariant;
    }

    @Override
    public Image getResolutionVariant(int width, int height) {
        return width <= this.getWidth() && height <= this.getHeight() ? this : this.resolutionVariant;
    }

    public Image getResolutionVariant() {
        return this.resolutionVariant;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.asList(this, this.resolutionVariant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageObserver getResolutionVariantObserver(final Image image, final ImageObserver observer, int imgWidth, int imgHeight, int rvWidth, int rvHeight) {
        if (observer == null) {
            return null;
        }
        SoftCache softCache = ObserverCache.INSTANCE;
        synchronized (softCache) {
            ImageObserver o = (ImageObserver)ObserverCache.INSTANCE.get(image);
            if (o == null) {
                o = new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image resolutionVariant, int flags, int x, int y, int width, int height) {
                        if ((flags & 0x39) != 0) {
                            width = (width + 1) / 2;
                        }
                        if ((flags & 0x3A) != 0) {
                            height = (height + 1) / 2;
                        }
                        if ((flags & 0x38) != 0) {
                            x /= 2;
                            y /= 2;
                        }
                        return observer.imageUpdate(image, flags, x, y, width, height);
                    }
                };
                ObserverCache.INSTANCE.put(image, o);
            }
            return o;
        }
    }

    private static class ObserverCache {
        static final SoftCache INSTANCE = new SoftCache();

        private ObserverCache() {
        }
    }
}

