/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.utils;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;

public abstract class FeaturePropertyBase {
    String[] values = null;
    State[] states = new State[]{State.DEFAULT, State.DEFAULT};

    public void setValue(Enum property, State state, String value) {
        if (state.compareTo(this.states[property.ordinal()]) >= 0) {
            this.values[property.ordinal()] = value;
            this.states[property.ordinal()] = state;
        }
    }

    public void setValue(int index, State state, String value) {
        if (state.compareTo(this.states[index]) >= 0) {
            this.values[index] = value;
            this.states[index] = state;
        }
    }

    public boolean setValue(String propertyName, State state, Object value) {
        int index = this.getIndex(propertyName);
        if (index > -1) {
            this.setValue(index, state, (String)value);
            return true;
        }
        return false;
    }

    public boolean setValue(String propertyName, State state, boolean value) {
        int index = this.getIndex(propertyName);
        if (index > -1) {
            if (value) {
                this.setValue(index, state, "true");
            } else {
                this.setValue(index, state, "false");
            }
            return true;
        }
        return false;
    }

    public String getValue(Enum property) {
        return this.values[property.ordinal()];
    }

    public String getValue(String property) {
        int index = this.getIndex(property);
        if (index > -1) {
            return this.getValueByIndex(index);
        }
        return null;
    }

    public String getValueAsString(String propertyName) {
        int index = this.getIndex(propertyName);
        if (index > -1) {
            return this.getValueByIndex(index);
        }
        return null;
    }

    public String getValueByIndex(int index) {
        return this.values[index];
    }

    public abstract int getIndex(String var1);

    public <E extends Enum<E>> int getIndex(Class<E> property, String propertyName) {
        for (Enum enumItem : (Enum[])property.getEnumConstants()) {
            if (!enumItem.toString().equals(propertyName)) continue;
            return enumItem.ordinal();
        }
        return -1;
    }

    void getSystemProperty(Enum property, String systemProperty) {
        try {
            String value = SecuritySupport.getSystemProperty(systemProperty);
            if (value != null) {
                this.values[property.ordinal()] = value;
                this.states[property.ordinal()] = State.SYSTEMPROPERTY;
                return;
            }
            value = SecuritySupport.readJAXPProperty(systemProperty);
            if (value != null) {
                this.values[property.ordinal()] = value;
                this.states[property.ordinal()] = State.JAXPDOTPROPERTIES;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static enum State {
        DEFAULT,
        FSP,
        JAXPDOTPROPERTIES,
        SYSTEMPROPERTY,
        APIPROPERTY;

    }
}

