/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HiddenTagView;

class CommentView
extends HiddenTagView {
    static final Border CBorder = new CommentBorder();
    static final int commentPadding = 3;
    static final int commentPaddingD = 9;

    CommentView(Element e) {
        super(e);
    }

    @Override
    protected Component createComponent() {
        Font font;
        Container host = this.getContainer();
        if (host != null && !((JTextComponent)host).isEditable()) {
            return null;
        }
        JTextArea ta = new JTextArea(this.getRepresentedText());
        Document doc = this.getDocument();
        if (doc instanceof StyledDocument) {
            font = ((StyledDocument)doc).getFont(this.getAttributes());
            ta.setFont(font);
        } else {
            font = ta.getFont();
        }
        this.updateYAlign(font);
        ta.setBorder(CBorder);
        ta.getDocument().addDocumentListener(this);
        ta.setFocusable(this.isVisible());
        return ta;
    }

    @Override
    void resetBorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void _updateModelFromText() {
        JTextComponent textC = this.getTextComponent();
        Document doc = this.getDocument();
        if (textC != null && doc != null) {
            String text = textC.getText();
            SimpleAttributeSet sas = new SimpleAttributeSet();
            this.isSettingAttributes = true;
            try {
                sas.addAttribute(HTML.Attribute.COMMENT, text);
                ((StyledDocument)doc).setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), sas, false);
            }
            finally {
                this.isSettingAttributes = false;
            }
        }
    }

    @Override
    JTextComponent getTextComponent() {
        return (JTextComponent)this.getComponent();
    }

    @Override
    String getRepresentedText() {
        Object comment;
        AttributeSet as = this.getElement().getAttributes();
        if (as != null && (comment = as.getAttribute(HTML.Attribute.COMMENT)) instanceof String) {
            return (String)comment;
        }
        return "";
    }

    static class CommentBorder
    extends LineBorder {
        CommentBorder() {
            super(Color.black, 1);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x + 3, y, width - 9, height);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets retI = super.getBorderInsets(c, insets);
            retI.left += 3;
            retI.right += 3;
            return retI;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

