/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.AttrFilter;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchFilterException;

public class SearchFilter
implements AttrFilter {
    String filter;
    int pos;
    private StringFilter rootFilter;
    protected static final boolean debug = false;
    protected static final char BEGIN_FILTER_TOKEN = '(';
    protected static final char END_FILTER_TOKEN = ')';
    protected static final char AND_TOKEN = '&';
    protected static final char OR_TOKEN = '|';
    protected static final char NOT_TOKEN = '!';
    protected static final char EQUAL_TOKEN = '=';
    protected static final char APPROX_TOKEN = '~';
    protected static final char LESS_TOKEN = '<';
    protected static final char GREATER_TOKEN = '>';
    protected static final char EXTEND_TOKEN = ':';
    protected static final char WILDCARD_TOKEN = '*';
    static final int EQUAL_MATCH = 1;
    static final int APPROX_MATCH = 2;
    static final int GREATER_MATCH = 3;
    static final int LESS_MATCH = 4;

    public SearchFilter(String filter) throws InvalidSearchFilterException {
        this.filter = filter;
        this.pos = 0;
        this.normalizeFilter();
        this.rootFilter = this.createNextFilter();
    }

    @Override
    public boolean check(Attributes targetAttrs) throws NamingException {
        if (targetAttrs == null) {
            return false;
        }
        return this.rootFilter.check(targetAttrs);
    }

    protected void normalizeFilter() {
        this.skipWhiteSpace();
        if (this.getCurrentChar() != '(') {
            this.filter = '(' + this.filter + ')';
        }
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.getCurrentChar())) {
            this.consumeChar();
        }
    }

    protected StringFilter createNextFilter() throws InvalidSearchFilterException {
        StringFilter filter;
        this.skipWhiteSpace();
        try {
            if (this.getCurrentChar() != '(') {
                throw new InvalidSearchFilterException("expected \"(\" at position " + this.pos);
            }
            this.consumeChar();
            this.skipWhiteSpace();
            switch (this.getCurrentChar()) {
                case '&': {
                    filter = new CompoundFilter(true);
                    filter.parse();
                    break;
                }
                case '|': {
                    filter = new CompoundFilter(false);
                    filter.parse();
                    break;
                }
                case '!': {
                    filter = new NotFilter();
                    filter.parse();
                    break;
                }
                default: {
                    filter = new AtomicFilter();
                    filter.parse();
                }
            }
            this.skipWhiteSpace();
            if (this.getCurrentChar() != ')') {
                throw new InvalidSearchFilterException("expected \")\" at position " + this.pos);
            }
            this.consumeChar();
        }
        catch (InvalidSearchFilterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidSearchFilterException("Unable to parse character " + this.pos + " in \"" + this.filter + "\"");
        }
        return filter;
    }

    protected char getCurrentChar() {
        return this.filter.charAt(this.pos);
    }

    protected char relCharAt(int i) {
        return this.filter.charAt(this.pos + i);
    }

    protected void consumeChar() {
        ++this.pos;
    }

    protected void consumeChars(int i) {
        this.pos += i;
    }

    protected int relIndexOf(int ch) {
        return this.filter.indexOf(ch, this.pos) - this.pos;
    }

    protected String relSubstring(int beginIndex, int endIndex) {
        return this.filter.substring(beginIndex + this.pos, endIndex + this.pos);
    }

    public static String format(Attributes attrs) throws NamingException {
        if (attrs == null || attrs.size() == 0) {
            return "objectClass=*";
        }
        String answer = "(& ";
        NamingEnumeration<? extends Attribute> e = attrs.getAll();
        while (e.hasMore()) {
            Attribute attr = e.next();
            if (attr.size() == 0 || attr.size() == 1 && attr.get() == null) {
                answer = answer + "(" + attr.getID() + "=" + "*)";
                continue;
            }
            NamingEnumeration<?> ve = attr.getAll();
            while (ve.hasMore()) {
                String val = SearchFilter.getEncodedStringRep(ve.next());
                if (val == null) continue;
                answer = answer + "(" + attr.getID() + "=" + val + ")";
            }
        }
        answer = answer + ")";
        return answer;
    }

    private static void hexDigit(StringBuffer buf, byte x) {
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        buf.append(c);
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        buf.append(c);
    }

    private static String getEncodedStringRep(Object obj) throws NamingException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            StringBuffer b1 = new StringBuffer(bytes.length * 3);
            for (int i = 0; i < bytes.length; ++i) {
                b1.append('\\');
                SearchFilter.hexDigit(b1, bytes[i]);
            }
            return b1.toString();
        }
        String str = !(obj instanceof String) ? obj.toString() : (String)obj;
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        block8: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '*': {
                    buf.append("\\2a");
                    continue block8;
                }
                case '(': {
                    buf.append("\\28");
                    continue block8;
                }
                case ')': {
                    buf.append("\\29");
                    continue block8;
                }
                case '\\': {
                    buf.append("\\5c");
                    continue block8;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block8;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static int findUnescaped(char ch, String val, int start) {
        int len = val.length();
        while (start < len) {
            int where = val.indexOf(ch, start);
            if (where == start || where == -1 || val.charAt(where - 1) != '\\') {
                return where;
            }
            start = where + 1;
        }
        return -1;
    }

    public static String format(String expr, Object[] args) throws NamingException {
        int where = 0;
        int start = 0;
        StringBuffer answer = new StringBuffer(expr.length());
        while ((where = SearchFilter.findUnescaped('{', expr, start)) >= 0) {
            int param;
            int pstart = where + 1;
            int pend = expr.indexOf(125, pstart);
            if (pend < 0) {
                throw new InvalidSearchFilterException("unbalanced {: " + expr);
            }
            try {
                param = Integer.parseInt(expr.substring(pstart, pend));
            }
            catch (NumberFormatException e) {
                throw new InvalidSearchFilterException("integer expected inside {}: " + expr);
            }
            if (param >= args.length) {
                throw new InvalidSearchFilterException("number exceeds argument list: " + param);
            }
            answer.append(expr.substring(start, where)).append(SearchFilter.getEncodedStringRep(args[param]));
            start = pend + 1;
        }
        if (start < expr.length()) {
            answer.append(expr.substring(start));
        }
        return answer.toString();
    }

    public static Attributes selectAttributes(Attributes originals, String[] attrIDs) throws NamingException {
        if (attrIDs == null) {
            return originals;
        }
        BasicAttributes result = new BasicAttributes();
        for (int i = 0; i < attrIDs.length; ++i) {
            Attribute attr = originals.get(attrIDs[i]);
            if (attr == null) continue;
            result.put(attr);
        }
        return result;
    }

    final class AtomicFilter
    implements StringFilter {
        private String attrID;
        private String value;
        private int matchType;

        AtomicFilter() {
        }

        @Override
        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.skipWhiteSpace();
            try {
                int endPos = SearchFilter.this.relIndexOf(41);
                int i = SearchFilter.this.relIndexOf(61);
                char qualifier = SearchFilter.this.relCharAt(i - 1);
                switch (qualifier) {
                    case '~': {
                        this.matchType = 2;
                        this.attrID = SearchFilter.this.relSubstring(0, i - 1);
                        this.value = SearchFilter.this.relSubstring(i + 1, endPos);
                        break;
                    }
                    case '>': {
                        this.matchType = 3;
                        this.attrID = SearchFilter.this.relSubstring(0, i - 1);
                        this.value = SearchFilter.this.relSubstring(i + 1, endPos);
                        break;
                    }
                    case '<': {
                        this.matchType = 4;
                        this.attrID = SearchFilter.this.relSubstring(0, i - 1);
                        this.value = SearchFilter.this.relSubstring(i + 1, endPos);
                        break;
                    }
                    case ':': {
                        throw new OperationNotSupportedException("Extensible match not supported");
                    }
                    default: {
                        this.matchType = 1;
                        this.attrID = SearchFilter.this.relSubstring(0, i);
                        this.value = SearchFilter.this.relSubstring(i + 1, endPos);
                    }
                }
                this.attrID = this.attrID.trim();
                this.value = this.value.trim();
                SearchFilter.this.consumeChars(endPos);
            }
            catch (Exception e) {
                InvalidSearchFilterException sfe = new InvalidSearchFilterException("Unable to parse character " + SearchFilter.this.pos + " in \"" + SearchFilter.this.filter + "\"");
                sfe.setRootCause(e);
                throw sfe;
            }
        }

        @Override
        public boolean check(Attributes targetAttrs) {
            NamingEnumeration<?> candidates;
            try {
                Attribute attr = targetAttrs.get(this.attrID);
                if (attr == null) {
                    return false;
                }
                candidates = attr.getAll();
            }
            catch (NamingException ne) {
                return false;
            }
            while (candidates.hasMoreElements()) {
                String val = candidates.nextElement().toString();
                switch (this.matchType) {
                    case 1: 
                    case 2: {
                        if (!this.substringMatch(this.value, val)) break;
                        return true;
                    }
                    case 3: {
                        if (val.compareTo(this.value) < 0) break;
                        return true;
                    }
                    case 4: {
                        if (val.compareTo(this.value) > 0) break;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean substringMatch(String proto, String value) {
            if (proto.equals(new Character('*').toString())) {
                return true;
            }
            if (proto.indexOf(42) == -1) {
                return proto.equalsIgnoreCase(value);
            }
            int currentPos = 0;
            StringTokenizer subStrs = new StringTokenizer(proto, "*", false);
            if (proto.charAt(0) != '*' && !value.toString().toLowerCase(Locale.ENGLISH).startsWith(subStrs.nextToken().toLowerCase(Locale.ENGLISH))) {
                return false;
            }
            while (subStrs.hasMoreTokens()) {
                String currentStr = subStrs.nextToken();
                currentPos = value.toLowerCase(Locale.ENGLISH).indexOf(currentStr.toLowerCase(Locale.ENGLISH), currentPos);
                if (currentPos == -1) {
                    return false;
                }
                currentPos += currentStr.length();
            }
            return proto.charAt(proto.length() - 1) == '*' || currentPos == value.length();
        }
    }

    final class NotFilter
    implements StringFilter {
        private StringFilter filter;

        NotFilter() {
        }

        @Override
        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            this.filter = SearchFilter.this.createNextFilter();
        }

        @Override
        public boolean check(Attributes targetAttrs) throws NamingException {
            return !this.filter.check(targetAttrs);
        }
    }

    final class CompoundFilter
    implements StringFilter {
        private Vector<StringFilter> subFilters = new Vector();
        private boolean polarity;

        CompoundFilter(boolean polarity) {
            this.polarity = polarity;
        }

        @Override
        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            while (SearchFilter.this.getCurrentChar() != ')') {
                StringFilter filter = SearchFilter.this.createNextFilter();
                this.subFilters.addElement(filter);
                SearchFilter.this.skipWhiteSpace();
            }
        }

        @Override
        public boolean check(Attributes targetAttrs) throws NamingException {
            for (int i = 0; i < this.subFilters.size(); ++i) {
                StringFilter filter = this.subFilters.elementAt(i);
                if (filter.check(targetAttrs) == this.polarity) continue;
                return !this.polarity;
            }
            return this.polarity;
        }
    }

    static interface StringFilter
    extends AttrFilter {
        public void parse() throws InvalidSearchFilterException;
    }
}

