/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class VMSupport {
    private static Properties agentProps = null;

    public static synchronized Properties getAgentProperties() {
        if (agentProps == null) {
            agentProps = new Properties();
            VMSupport.initAgentProperties(agentProps);
        }
        return agentProps;
    }

    private static native Properties initAgentProperties(Properties var0);

    private static byte[] serializePropertiesToByteArray(Properties p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        Properties props = new Properties();
        Set<String> keyset = p.stringPropertyNames();
        for (String key : keyset) {
            String value = p.getProperty(key);
            props.put(key, value);
        }
        props.store(out, null);
        return out.toByteArray();
    }

    public static byte[] serializePropertiesToByteArray() throws IOException {
        return VMSupport.serializePropertiesToByteArray(System.getProperties());
    }

    public static byte[] serializeAgentPropertiesToByteArray() throws IOException {
        return VMSupport.serializePropertiesToByteArray(VMSupport.getAgentProperties());
    }

    public static boolean isClassPathAttributePresent(String path) {
        try {
            Manifest man = new JarFile(path).getManifest();
            return man != null && man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH) != null;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public static native String getVMTemporaryDirectory();
}

