/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.XMLDocumentScannerImpl;
import com.sun.org.apache.xerces.internal.impl.XMLScanner;
import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import java.io.IOException;

public class XML11DocumentScannerImpl
extends XMLDocumentScannerImpl {
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private final XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private final XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();

    @Override
    protected int scanContent(XMLStringBuffer content) throws IOException, XNIException {
        this.fTempString.length = 0;
        int c = this.fEntityScanner.scanContent(this.fTempString);
        content.append(this.fTempString);
        if (c == 13 || c == 133 || c == 8232) {
            this.fEntityScanner.scanChar(null);
            content.append((char)c);
            c = -1;
        }
        if (c == 93) {
            content.append((char)this.fEntityScanner.scanChar(null));
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93, null)) {
                content.append(']');
                while (this.fEntityScanner.skipChar(93, null)) {
                    content.append(']');
                }
                if (this.fEntityScanner.skipChar(62, null)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            this.fInScanContent = false;
            c = -1;
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean scanAttributeValue(XMLString value, XMLString nonNormalizedValue, String atName, boolean checkEntities, String eleName, boolean isNSURI) throws IOException, XNIException {
        int quote;
        block28: {
            quote = this.fEntityScanner.peekChar();
            if (quote != 39 && quote != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{eleName, atName});
            }
            this.fEntityScanner.scanChar(XMLScanner.NameType.ATTRIBUTE);
            int entityDepth = this.fEntityDepth;
            int c = this.fEntityScanner.scanLiteral(quote, value, isNSURI);
            int fromIndex = 0;
            if (c == quote && (fromIndex = this.isUnchangedByNormalization(value)) == -1) {
                nonNormalizedValue.setValues(value);
                int cquote = this.fEntityScanner.scanChar(XMLScanner.NameType.ATTRIBUTE);
                if (cquote != quote) {
                    this.reportFatalError("CloseQuoteExpected", new Object[]{eleName, atName});
                }
                return true;
            }
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(value);
            this.normalizeWhitespace(value, fromIndex);
            if (c == quote) break block28;
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                block31: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block29: {
                                        String entityName;
                                        block32: {
                                            block30: {
                                                int ch;
                                                this.fStringBuffer.append(value);
                                                if (c != 38) break block29;
                                                this.fEntityScanner.skipChar(38, XMLScanner.NameType.REFERENCE);
                                                if (entityDepth == this.fEntityDepth) {
                                                    this.fStringBuffer2.append('&');
                                                }
                                                if (!this.fEntityScanner.skipChar(35, XMLScanner.NameType.REFERENCE)) break block30;
                                                if (entityDepth == this.fEntityDepth) {
                                                    this.fStringBuffer2.append('#');
                                                }
                                                if ((ch = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) == -1) {
                                                    // empty if block
                                                }
                                                break block31;
                                            }
                                            entityName = this.fEntityScanner.scanName(XMLScanner.NameType.REFERENCE);
                                            if (entityName == null) {
                                                this.reportFatalError("NameRequiredInReference", null);
                                            } else if (entityDepth == this.fEntityDepth) {
                                                this.fStringBuffer2.append(entityName);
                                            }
                                            if (!this.fEntityScanner.skipChar(59, XMLScanner.NameType.REFERENCE)) {
                                                this.reportFatalError("SemicolonRequiredInReference", new Object[]{entityName});
                                            } else if (entityDepth == this.fEntityDepth) {
                                                this.fStringBuffer2.append(';');
                                            }
                                            if (!this.resolveCharacter(entityName, this.fStringBuffer)) break block32;
                                            this.checkEntityLimit(false, this.fEntityScanner.fCurrentEntity.name, 1);
                                            break block31;
                                        }
                                        if (this.fEntityManager.isExternalEntity(entityName)) {
                                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{entityName});
                                            break block31;
                                        } else {
                                            if (!this.fEntityManager.isDeclaredEntity(entityName)) {
                                                if (checkEntities) {
                                                    if (this.fValidation) {
                                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{entityName}, (short)1);
                                                    }
                                                } else {
                                                    this.reportFatalError("EntityNotDeclared", new Object[]{entityName});
                                                }
                                            }
                                            this.fEntityManager.startEntity(true, entityName, true);
                                        }
                                        break block31;
                                    }
                                    if (c != 60) break block33;
                                    this.reportFatalError("LessthanInAttValue", new Object[]{eleName, atName});
                                    this.fEntityScanner.scanChar(null);
                                    if (entityDepth == this.fEntityDepth) {
                                        this.fStringBuffer2.append((char)c);
                                    }
                                    break block31;
                                }
                                if (c != 37 && c != 93) break block34;
                                this.fEntityScanner.scanChar(null);
                                this.fStringBuffer.append((char)c);
                                if (entityDepth == this.fEntityDepth) {
                                    this.fStringBuffer2.append((char)c);
                                }
                                break block31;
                            }
                            if (c != 10 && c != 13 && c != 133 && c != 8232) break block35;
                            this.fEntityScanner.scanChar(null);
                            this.fStringBuffer.append(' ');
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append('\n');
                            }
                            break block31;
                        }
                        if (c == -1 || !XMLChar.isHighSurrogate(c)) break block36;
                        this.fStringBuffer3.clear();
                        if (this.scanSurrogates(this.fStringBuffer3)) {
                            this.fStringBuffer.append(this.fStringBuffer3);
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append(this.fStringBuffer3);
                            }
                        }
                        break block31;
                    }
                    if (c != -1 && this.isInvalidLiteral(c)) {
                        this.reportFatalError("InvalidCharInAttValue", new Object[]{eleName, atName, Integer.toString(c, 16)});
                        this.fEntityScanner.scanChar(null);
                        if (entityDepth == this.fEntityDepth) {
                            this.fStringBuffer2.append((char)c);
                        }
                    }
                }
                c = this.fEntityScanner.scanLiteral(quote, value, isNSURI);
                if (entityDepth == this.fEntityDepth) {
                    this.fStringBuffer2.append(value);
                }
                this.normalizeWhitespace(value);
            } while (c != quote || entityDepth != this.fEntityDepth);
            this.fStringBuffer.append(value);
            value.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        nonNormalizedValue.setValues(this.fStringBuffer2);
        int cquote = this.fEntityScanner.scanChar(null);
        if (cquote != quote) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{eleName, atName});
        }
        return nonNormalizedValue.equals(value.ch, value.offset, value.length);
    }

    @Override
    protected boolean scanPubidLiteral(XMLString literal) throws IOException, XNIException {
        int quote = this.fEntityScanner.scanChar(null);
        if (quote != 39 && quote != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean skipSpace = true;
        boolean dataok = true;
        while (true) {
            int c;
            if ((c = this.fEntityScanner.scanChar(null)) == 32 || c == 10 || c == 13 || c == 133 || c == 8232) {
                if (skipSpace) continue;
                this.fStringBuffer.append(' ');
                skipSpace = true;
                continue;
            }
            if (c == quote) {
                if (skipSpace) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(c)) {
                this.fStringBuffer.append((char)c);
                skipSpace = false;
                continue;
            }
            if (c == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            dataok = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(c)});
        }
        literal.setValues(this.fStringBuffer);
        return dataok;
    }

    @Override
    protected void normalizeWhitespace(XMLString value) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            char c = value.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            value.ch[i] = 32;
        }
    }

    protected void normalizeWhitespace(XMLString value, int fromIndex) {
        int end = value.offset + value.length;
        for (int i = value.offset + fromIndex; i < end; ++i) {
            char c = value.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            value.ch[i] = 32;
        }
    }

    protected int isUnchangedByNormalization(XMLString value) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            char c = value.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            return i - value.offset;
        }
        return -1;
    }

    @Override
    protected boolean isInvalid(int value) {
        return XML11Char.isXML11Invalid(value);
    }

    @Override
    protected boolean isInvalidLiteral(int value) {
        return !XML11Char.isXML11ValidLiteral(value);
    }

    @Override
    protected boolean isValidNameChar(int value) {
        return XML11Char.isXML11Name(value);
    }

    @Override
    protected boolean isValidNameStartChar(int value) {
        return XML11Char.isXML11NameStart(value);
    }

    @Override
    protected boolean isValidNCName(int value) {
        return XML11Char.isXML11NCName(value);
    }

    protected boolean isValidNameStartHighSurrogate(int value) {
        return XML11Char.isXML11NameHighSurrogate(value);
    }

    @Override
    protected boolean versionSupported(String version) {
        return version.equals("1.1") || version.equals("1.0");
    }

    protected String getVersionNotSupportedKey() {
        return "VersionNotSupported11";
    }
}

