/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.net.MalformedURLException;

public class Uri {
    protected String uri;
    protected String scheme;
    protected String host = null;
    protected int port = -1;
    protected boolean hasAuthority;
    protected String path;
    protected String query = null;

    public Uri(String uri) throws MalformedURLException {
        this.init(uri);
    }

    protected Uri() {
    }

    protected void init(String uri) throws MalformedURLException {
        this.uri = uri;
        this.parse(uri);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return this.uri;
    }

    private void parse(String uri) throws MalformedURLException {
        int qmark;
        int i = uri.indexOf(58);
        if (i < 0) {
            throw new MalformedURLException("Invalid URI: " + uri);
        }
        this.scheme = uri.substring(0, i);
        this.hasAuthority = uri.startsWith("//", ++i);
        if (this.hasAuthority) {
            int slash = uri.indexOf(47, i += 2);
            if (slash < 0) {
                slash = uri.length();
            }
            if (uri.startsWith("[", i)) {
                int brac = uri.indexOf(93, i + 1);
                if (brac < 0 || brac > slash) {
                    throw new MalformedURLException("Invalid URI: " + uri);
                }
                this.host = uri.substring(i, brac + 1);
                i = brac + 1;
            } else {
                int hostEnd;
                int colon = uri.indexOf(58, i);
                int n = hostEnd = colon < 0 || colon > slash ? slash : colon;
                if (i < hostEnd) {
                    this.host = uri.substring(i, hostEnd);
                }
                i = hostEnd;
            }
            if (i + 1 < slash && uri.startsWith(":", i)) {
                this.port = Integer.parseInt(uri.substring(++i, slash));
            }
            i = slash;
        }
        if ((qmark = uri.indexOf(63, i)) < 0) {
            this.path = uri.substring(i);
        } else {
            this.path = uri.substring(i, qmark);
            this.query = uri.substring(qmark);
        }
    }
}

