/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class AttributeChangeNotificationFilter
implements NotificationFilter {
    private static final long serialVersionUID = -6347317584796410029L;
    private Vector<String> enabledAttributes = new Vector();

    @Override
    public synchronized boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        if (type == null || !type.equals("jmx.attribute.change") || !(notification instanceof AttributeChangeNotification)) {
            return false;
        }
        String attributeName = ((AttributeChangeNotification)notification).getAttributeName();
        return this.enabledAttributes.contains(attributeName);
    }

    public synchronized void enableAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        if (!this.enabledAttributes.contains(name)) {
            this.enabledAttributes.addElement(name);
        }
    }

    public synchronized void disableAttribute(String name) {
        this.enabledAttributes.removeElement(name);
    }

    public synchronized void disableAllAttributes() {
        this.enabledAttributes.removeAllElements();
    }

    public synchronized Vector<String> getEnabledAttributes() {
        return this.enabledAttributes;
    }
}

