/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AwsConventionsHelper {
    public static final Pattern AMAZON_URL = Pattern.compile("([^.]+)(\\.[^.]+)?\\.amazonaws\\.com(\\.[a-z]+)?$");
    public static final String DEFAULT_REGION = "us-east-1";
    private static final String DEFAULT_SUFFIX = ".amazonaws.com";
    private static final Map<String, String> REGION_SUFFIX_OVERRIDE;

    public static String setUrlRegion(String url, String region) {
        if (StringUtils.isEmpty(url) || StringUtils.isEmpty(region)) {
            return url;
        }
        Matcher matcher = AMAZON_URL.matcher(url);
        if (!matcher.find()) {
            return url;
        }
        String serviceName = matcher.group(1);
        String regionSuffix = DEFAULT_SUFFIX;
        if (REGION_SUFFIX_OVERRIDE.containsKey(region)) {
            regionSuffix = REGION_SUFFIX_OVERRIDE.get(region);
        }
        return serviceName + "." + region + regionSuffix;
    }

    static {
        HashMap<String, String> suffixOverride = new HashMap<String, String>();
        suffixOverride.put("cn-north-1", ".amazonaws.com.cn");
        REGION_SUFFIX_OVERRIDE = Collections.unmodifiableMap(suffixOverride);
    }
}

