/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;

public class ClipboardTransferable
implements Transferable {
    private final HashMap flavorsToData = new HashMap();
    private DataFlavor[] flavors = new DataFlavor[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardTransferable(SunClipboard clipboard) {
        clipboard.openClipboard(null);
        try {
            long[] formats = clipboard.getClipboardFormats();
            if (formats != null && formats.length > 0) {
                HashMap cached_data = new HashMap(formats.length, 1.0f);
                Map flavorsForFormats = DataTransferer.getInstance().getFlavorsForFormats(formats, SunClipboard.getDefaultFlavorTable());
                for (DataFlavor flavor : flavorsForFormats.keySet()) {
                    Long lFormat = (Long)flavorsForFormats.get(flavor);
                    this.fetchOneFlavor(clipboard, flavor, lFormat, cached_data);
                }
                DataTransferer.getInstance();
                this.flavors = DataTransferer.setToSortedDataFlavorArray(this.flavorsToData.keySet());
            }
        }
        finally {
            clipboard.closeClipboard();
        }
    }

    private boolean fetchOneFlavor(SunClipboard clipboard, DataFlavor flavor, Long lFormat, HashMap cached_data) {
        if (!this.flavorsToData.containsKey(flavor)) {
            long format = lFormat;
            Object data = null;
            if (!cached_data.containsKey(lFormat)) {
                try {
                    data = clipboard.getClipboardData(format);
                }
                catch (IOException e) {
                    data = e;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                cached_data.put(lFormat, data);
            } else {
                data = cached_data.get(lFormat);
            }
            if (data instanceof IOException) {
                this.flavorsToData.put(flavor, data);
                return false;
            }
            if (data != null) {
                this.flavorsToData.put(flavor, new DataFactory(format, (byte[])data));
                return true;
            }
        }
        return false;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavorsToData.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        Object ret = this.flavorsToData.get(flavor);
        if (ret instanceof IOException) {
            throw (IOException)ret;
        }
        if (ret instanceof DataFactory) {
            DataFactory factory = (DataFactory)ret;
            ret = factory.getTransferData(flavor);
        }
        return ret;
    }

    private final class DataFactory {
        final long format;
        final byte[] data;

        DataFactory(long format, byte[] data) {
            this.format = format;
            this.data = data;
        }

        public Object getTransferData(DataFlavor flavor) throws IOException {
            return DataTransferer.getInstance().translateBytes(this.data, flavor, this.format, ClipboardTransferable.this);
        }
    }
}

