/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class NegTokenInit
extends SpNegoToken {
    private byte[] mechTypes = null;
    private Oid[] mechTypeList = null;
    private BitArray reqFlags = null;
    private byte[] mechToken = null;
    private byte[] mechListMIC = null;

    NegTokenInit(byte[] mechTypes, BitArray flags, byte[] token, byte[] mechListMIC) {
        super(0);
        this.mechTypes = mechTypes;
        this.reqFlags = flags;
        this.mechToken = token;
        this.mechListMIC = mechListMIC;
    }

    public NegTokenInit(byte[] in) throws GSSException {
        super(0);
        this.parseToken(in);
    }

    @Override
    final byte[] encode() throws GSSException {
        try {
            DerOutputStream initToken = new DerOutputStream();
            if (this.mechTypes != null) {
                initToken.write(DerValue.createTag((byte)-128, true, (byte)0), this.mechTypes);
            }
            if (this.reqFlags != null) {
                DerOutputStream flags = new DerOutputStream();
                flags.putUnalignedBitString(this.reqFlags);
                initToken.write(DerValue.createTag((byte)-128, true, (byte)1), flags);
            }
            if (this.mechToken != null) {
                DerOutputStream dataValue = new DerOutputStream();
                dataValue.putOctetString(this.mechToken);
                initToken.write(DerValue.createTag((byte)-128, true, (byte)2), dataValue);
            }
            if (this.mechListMIC != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenInit: sending MechListMIC");
                }
                DerOutputStream mic = new DerOutputStream();
                mic.putOctetString(this.mechListMIC);
                initToken.write(DerValue.createTag((byte)-128, true, (byte)3), mic);
            }
            DerOutputStream out = new DerOutputStream();
            out.write((byte)48, initToken);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenInit token : " + e.getMessage());
        }
    }

    private void parseToken(byte[] in) throws GSSException {
        try {
            DerValue der = new DerValue(in);
            if (!der.isContextSpecific((byte)0)) {
                throw new IOException("SPNEGO NegoTokenInit : did not have right token type");
            }
            DerValue tmp1 = der.data.getDerValue();
            if (tmp1.tag != 48) {
                throw new IOException("SPNEGO NegoTokenInit : did not have the Sequence tag");
            }
            int lastField = -1;
            while (tmp1.data.available() > 0) {
                DerValue tmp2 = tmp1.data.getDerValue();
                if (tmp2.isContextSpecific((byte)0)) {
                    lastField = NegTokenInit.checkNextField(lastField, 0);
                    DerInputStream mValue = tmp2.data;
                    this.mechTypes = mValue.toByteArray();
                    DerValue[] mList = mValue.getSequence(0);
                    this.mechTypeList = new Oid[mList.length];
                    ObjectIdentifier mech = null;
                    for (int i = 0; i < mList.length; ++i) {
                        mech = mList[i].getOID();
                        if (DEBUG) {
                            System.out.println("SpNegoToken NegTokenInit: reading Mechanism Oid = " + mech);
                        }
                        this.mechTypeList[i] = new Oid(mech.toString());
                    }
                    continue;
                }
                if (tmp2.isContextSpecific((byte)1)) {
                    lastField = NegTokenInit.checkNextField(lastField, 1);
                    continue;
                }
                if (tmp2.isContextSpecific((byte)2)) {
                    lastField = NegTokenInit.checkNextField(lastField, 2);
                    if (DEBUG) {
                        System.out.println("SpNegoToken NegTokenInit: reading Mech Token");
                    }
                    this.mechToken = tmp2.data.getOctetString();
                    continue;
                }
                if (!tmp2.isContextSpecific((byte)3)) continue;
                lastField = NegTokenInit.checkNextField(lastField, 3);
                if (GSSUtil.useMSInterop()) continue;
                this.mechListMIC = tmp2.data.getOctetString();
                if (!DEBUG) continue;
                System.out.println("SpNegoToken NegTokenInit: MechListMIC Token = " + NegTokenInit.getHexBytes(this.mechListMIC));
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenInit token : " + e.getMessage());
        }
    }

    byte[] getMechTypes() {
        return this.mechTypes;
    }

    public Oid[] getMechTypeList() {
        return this.mechTypeList;
    }

    BitArray getReqFlags() {
        return this.reqFlags;
    }

    public byte[] getMechToken() {
        return this.mechToken;
    }

    byte[] getMechListMIC() {
        return this.mechListMIC;
    }
}

