/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

class WindowDimensions {
    private Point loc;
    private Dimension size;
    private Insets insets;
    private boolean isClientSizeSet;

    public WindowDimensions(int x, int y, int width, int height, boolean isClient) {
        this(new Rectangle(x, y, width, height), null, isClient);
    }

    public WindowDimensions(Rectangle rec, Insets ins, boolean isClient) {
        if (rec == null) {
            throw new IllegalArgumentException("Client bounds can't be null");
        }
        this.isClientSizeSet = isClient;
        this.loc = rec.getLocation();
        this.size = rec.getSize();
        this.setInsets(ins);
    }

    public WindowDimensions(Point loc, Dimension size, Insets in, boolean isClient) {
        this(new Rectangle(loc, size), in, isClient);
    }

    public WindowDimensions(Rectangle bounds, boolean isClient) {
        this(bounds, null, isClient);
    }

    public WindowDimensions(WindowDimensions dims) {
        this.loc = new Point(dims.loc);
        this.size = new Dimension(dims.size);
        this.insets = dims.insets != null ? (Insets)dims.insets.clone() : new Insets(0, 0, 0, 0);
        this.isClientSizeSet = dims.isClientSizeSet;
    }

    public Rectangle getClientRect() {
        if (this.isClientSizeSet) {
            return new Rectangle(this.loc, this.size);
        }
        if (this.insets != null) {
            return new Rectangle(this.loc.x, this.loc.y, this.size.width - (this.insets.left + this.insets.right), this.size.height - (this.insets.top + this.insets.bottom));
        }
        return new Rectangle(this.loc, this.size);
    }

    public void setClientSize(Dimension size) {
        this.size = new Dimension(size);
        this.isClientSizeSet = true;
    }

    public void setClientSize(int width, int height) {
        this.size = new Dimension(width, height);
        this.isClientSizeSet = true;
    }

    public Dimension getClientSize() {
        return this.getClientRect().getSize();
    }

    public void setSize(int width, int height) {
        this.size = new Dimension(width, height);
        this.isClientSizeSet = false;
    }

    public Dimension getSize() {
        return this.getBounds().getSize();
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public Rectangle getBounds() {
        if (this.isClientSizeSet) {
            Rectangle res = new Rectangle(this.loc, this.size);
            res.width += this.insets.left + this.insets.right;
            res.height += this.insets.top + this.insets.bottom;
            return res;
        }
        return new Rectangle(this.loc, this.size);
    }

    public Point getLocation() {
        return new Point(this.loc);
    }

    public void setLocation(int x, int y) {
        this.loc = new Point(x, y);
    }

    public Rectangle getScreenBounds() {
        Dimension size = this.getClientSize();
        Point location = this.getLocation();
        location.x += this.insets.left;
        location.y += this.insets.top;
        return new Rectangle(location, size);
    }

    public void setInsets(Insets in) {
        Insets insets = this.insets = in != null ? (Insets)in.clone() : new Insets(0, 0, 0, 0);
        if (!this.isClientSizeSet) {
            if (this.size.width < this.insets.left + this.insets.right) {
                this.size.width = this.insets.left + this.insets.right;
            }
            if (this.size.height < this.insets.top + this.insets.bottom) {
                this.size.height = this.insets.top + this.insets.bottom;
            }
        }
    }

    public boolean isClientSizeSet() {
        return this.isClientSizeSet;
    }

    public String toString() {
        return "[" + this.loc + ", " + this.size + "(" + (this.isClientSizeSet ? "client" : "bounds") + ")+" + this.insets + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof WindowDimensions)) {
            return false;
        }
        WindowDimensions dims = (WindowDimensions)o;
        return dims.insets.equals(this.insets) && this.getClientRect().equals(dims.getClientRect()) && this.getBounds().equals(dims.getBounds());
    }

    public int hashCode() {
        return (this.insets == null ? 0 : this.insets.hashCode()) ^ this.getClientRect().hashCode() ^ this.getBounds().hashCode();
    }
}

