/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Spans {
    private static final int kMaxAddsSinceSort = 256;
    private List mSpans = new Vector(256);
    private int mAddsSinceSort = 0;

    public void add(float start, float end) {
        if (this.mSpans != null) {
            this.mSpans.add(new Span(start, end));
            if (++this.mAddsSinceSort >= 256) {
                this.sortAndCollapse();
            }
        }
    }

    public void addInfinite() {
        this.mSpans = null;
    }

    public boolean intersects(float start, float end) {
        boolean doesIntersect;
        if (this.mSpans != null) {
            int found;
            if (this.mAddsSinceSort > 0) {
                this.sortAndCollapse();
            }
            doesIntersect = (found = Collections.binarySearch(this.mSpans, new Span(start, end), SpanIntersection.instance)) >= 0;
        } else {
            doesIntersect = true;
        }
        return doesIntersect;
    }

    private void sortAndCollapse() {
        Collections.sort(this.mSpans);
        this.mAddsSinceSort = 0;
        Iterator iter = this.mSpans.iterator();
        Span span = null;
        if (iter.hasNext()) {
            span = (Span)iter.next();
        }
        while (iter.hasNext()) {
            Span nextSpan = (Span)iter.next();
            if (span.subsume(nextSpan)) {
                iter.remove();
                continue;
            }
            span = nextSpan;
        }
    }

    static class SpanIntersection
    implements Comparator {
        static final SpanIntersection instance = new SpanIntersection();

        private SpanIntersection() {
        }

        public int compare(Object o1, Object o2) {
            Span span1 = (Span)o1;
            Span span2 = (Span)o2;
            int result = span1.getEnd() <= span2.getStart() ? -1 : (span1.getStart() >= span2.getEnd() ? 1 : 0);
            return result;
        }
    }

    static class Span
    implements Comparable {
        private float mStart;
        private float mEnd;

        Span(float start, float end) {
            this.mStart = start;
            this.mEnd = end;
        }

        final float getStart() {
            return this.mStart;
        }

        final float getEnd() {
            return this.mEnd;
        }

        final void setStart(float start) {
            this.mStart = start;
        }

        final void setEnd(float end) {
            this.mEnd = end;
        }

        boolean subsume(Span otherSpan) {
            boolean isSubsumed = this.contains(otherSpan.mStart);
            if (isSubsumed && otherSpan.mEnd > this.mEnd) {
                this.mEnd = otherSpan.mEnd;
            }
            return isSubsumed;
        }

        boolean contains(float pos) {
            return this.mStart <= pos && pos < this.mEnd;
        }

        public int compareTo(Object o) {
            Span otherSpan = (Span)o;
            float otherStart = otherSpan.getStart();
            int result = this.mStart < otherStart ? -1 : (this.mStart > otherStart ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Span: " + this.mStart + " to " + this.mEnd;
        }
    }
}

