/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.vmconversion.AsciiProgressBar;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.Slice;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import com.amazon.aes.webservices.client.vmconversionschema.Part;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.jets3t.service.io.BytesProgressWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Importer {
    Manifest manifest;
    String bucketName;
    File file;
    private static final String PART_SUFFIX = "part";
    private static final String CANCELLED_TASK_STATUS = "cancelled";
    private static final String CANCELLING_TASK_STATUS = "cancelling";
    private static final String ACTIVE_TASK_STATUS = "active";
    private static final int DESCRIBE_THREAD_SLEEP_TIME_MILLISEC = 30000;
    private static final int NUM_FAILED_RETRIES = 5;
    private final AmazonS3 s3Client;

    public Importer(Manifest manifest, AmazonS3 s3Client, String bucketName, File file) {
        this.manifest = manifest;
        this.bucketName = bucketName;
        this.file = file;
        this.s3Client = s3Client;
    }

    private String getCommonPrefix() throws VerificationException {
        Part part = this.manifest.getImport().getParts().getPart().get(0);
        String prefix = part.getKey().replaceFirst("part\\d+$", PART_SUFFIX);
        if (!prefix.endsWith(PART_SUFFIX)) {
            throw new VerificationException("Unable to determine common prefix for " + part.getKey());
        }
        return prefix;
    }

    private Map<String, S3ObjectSummary> findExistingParts(String prefix) throws AmazonServiceException, AmazonClientException {
        HashMap<String, S3ObjectSummary> existingParts = new HashMap<String, S3ObjectSummary>();
        List objectSummaries = this.s3Client.listObjects(this.bucketName, prefix).getObjectSummaries();
        for (S3ObjectSummary objectSummary : objectSummaries) {
            existingParts.put(objectSummary.getKey(), objectSummary);
        }
        return existingParts;
    }

    private boolean doPartsShareCommonPrefix(String prefix) {
        for (Part part : this.manifest.getImport().getParts().getPart()) {
            if (part.getKey().startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public void startOrResumeImport(final Jec2 jec2, final String taskId) throws AmazonServiceException, AmazonClientException, VerificationException {
        String commonPrefix = this.getCommonPrefix();
        Map<String, S3ObjectSummary> existingParts = null;
        if (commonPrefix == null || !this.doPartsShareCommonPrefix(commonPrefix)) {
            throw new VerificationException("Manifest Validation failed. No common prefix found for uploading file parts");
        }
        existingParts = this.findExistingParts(commonPrefix);
        final ExecutorService threadPool = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("max-thread-count", "2")));
        ArrayList tasks = new ArrayList();
        ExecutorService describeThread = Executors.newSingleThreadExecutor();
        Future<String> describeTask = describeThread.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String taskState = Importer.ACTIVE_TASK_STATUS;
                String taskStatusMessage = null;
                while (!(Importer.CANCELLED_TASK_STATUS.equals(taskState) || Importer.CANCELLING_TASK_STATUS.equals(taskState) || threadPool.isShutdown())) {
                    try {
                        ConversionTaskDescription task = jec2.describeConversionTask(taskId);
                        taskState = task.getStatus().toLowerCase();
                        taskStatusMessage = task.getStatusMessage();
                    }
                    catch (Exception e) {
                        taskState = Importer.ACTIVE_TASK_STATUS;
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (Importer.CANCELLED_TASK_STATUS.equals(taskState) || Importer.CANCELLING_TASK_STATUS.equals(taskState)) {
                    threadPool.shutdownNow();
                }
                return taskStatusMessage;
            }
        });
        List<Part> parts = this.manifest.getImport().getParts().getPart();
        BytesProgressWatcher[] progressWatchers = new BytesProgressWatcher[parts.size()];
        final AtomicLong bytesActuallyTransferred = new AtomicLong();
        long start = System.currentTimeMillis();
        System.out.println("Uploading " + this.manifest.getImport().getSize() + " bytes across " + parts.size() + " parts");
        for (int i = 0; i < parts.size(); ++i) {
            BytesProgressWatcher progressWatcher;
            final Part part = parts.get(i);
            final long partSize = part.getByteRange().getEnd() - part.getByteRange().getStart() + 1L;
            progressWatchers[i] = progressWatcher = new BytesProgressWatcher(partSize);
            if (existingParts != null && existingParts.containsKey(part.getKey())) {
                progressWatcher.updateBytesTransferred(partSize);
                continue;
            }
            final boolean doHead = existingParts == null;
            tasks.add(threadPool.submit(new Runnable(){

                public void run() {
                    for (int numRetries = 0; numRetries < 5 && !threadPool.isShutdown(); ++numRetries) {
                        try {
                            if (doHead) {
                                boolean partExists;
                                try {
                                    Importer.this.s3Client.getObjectMetadata(Importer.this.bucketName, part.getKey());
                                    partExists = true;
                                }
                                catch (AmazonServiceException e) {
                                    switch (e.getStatusCode()) {
                                        case 403: {
                                            partExists = true;
                                            break;
                                        }
                                        case 404: {
                                            partExists = false;
                                            break;
                                        }
                                        default: {
                                            throw e;
                                        }
                                    }
                                }
                                if (partExists) {
                                    progressWatcher.updateBytesTransferred(partSize);
                                    return;
                                }
                            }
                            Slice slice = new Slice(Importer.this.file, part);
                            PutObjectRequest putObjectRequest = slice.createPutObjectRequest(Importer.this.bucketName);
                            putObjectRequest.setGeneralProgressListener(new ProgressListener(){

                                public void progressChanged(ProgressEvent progressEvent) {
                                    progressWatcher.updateBytesTransferred(progressEvent.getBytesTransferred());
                                }
                            });
                            Importer.this.s3Client.putObject(putObjectRequest);
                            bytesActuallyTransferred.addAndGet(putObjectRequest.getFile().length());
                            slice.deleteFile();
                            return;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    throw new InternalException("Failed uploading part " + part.getKey() + ", please try again shortly.");
                }
            }));
        }
        boolean failed = false;
        boolean taskCancelled = false;
        ExecutorService executorsProgressBar = Executors.newFixedThreadPool(1);
        AsciiProgressBar progressBar = new AsciiProgressBar(this.manifest.getImport().getSize(), start, AsciiProgressBar.BarCallerType.IMPORTER, System.out);
        progressBar.preamble();
        Future<?> futureProgressBar = executorsProgressBar.submit(progressBar);
        long bytesTransferred = 0L;
        while (true) {
            boolean allPartsUploaded = true;
            for (Future future : tasks) {
                if (future.isDone()) {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                    continue;
                }
                allPartsUploaded = false;
                break;
            }
            long newBytesTransferred = BytesProgressWatcher.sumBytesTransferred(progressWatchers);
            progressBar.updateCompleted(newBytesTransferred);
            bytesTransferred = newBytesTransferred;
            if (allPartsUploaded) break;
            if (threadPool.isTerminated()) {
                taskCancelled = true;
                for (Future future : tasks) {
                    future.cancel(true);
                }
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new InternalException(e.getMessage());
            }
        }
        while (true) {
            if (!futureProgressBar.isDone()) continue;
            try {
                futureProgressBar.get();
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
        executorsProgressBar.shutdownNow();
        progressBar.postamble();
        long end = System.currentTimeMillis();
        double d = (double)bytesActuallyTransferred.get() / ((double)(end - start) / 1000.0);
        double d2 = d / 1000000.0;
        System.out.println(String.format("Average speed was %.3f MBps", d2));
        threadPool.shutdown();
        describeThread.shutdownNow();
        if (taskCancelled) {
            String errMessage = "Upload aborted. ";
            try {
                errMessage = errMessage + "Task " + taskId + " is cancelled with status message " + describeTask.get() + ".\n";
            }
            catch (Exception e) {
                errMessage = errMessage + "Task " + taskId + " is cancelled.\n";
            }
            errMessage = errMessage + "You may use ec2-delete-disk-image to remove partially uploaded image from S3.";
            throw new VerificationException(errMessage);
        }
        if (failed) {
            throw new InternalException("Failed to upload complete file, please retry the upload.");
        }
    }
}

