/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.ProcessPath;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.xr.MaskTileManager;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class XRRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    XRDrawHandler drawHandler;
    MaskTileManager tileManager;

    public XRRenderer(MaskTileManager tileManager) {
        this.tileManager = tileManager;
        this.drawHandler = new XRDrawHandler();
    }

    private final void validateSurface(SunGraphics2D sg2d) {
        XRSurfaceData xrsd = (XRSurfaceData)sg2d.surfaceData;
        xrsd.validateAsDestination(sg2d, sg2d.getCompClip());
        xrsd.maskBuffer.validateCompositeState(sg2d.composite, sg2d.transform, sg2d.paint, sg2d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawLine(SunGraphics2D sg2d, int x1, int y1, int x2, int y2) {
        Region compClip = sg2d.getCompClip();
        int transX1 = Region.clipAdd(x1, sg2d.transX);
        int transY1 = Region.clipAdd(y1, sg2d.transY);
        int transX2 = Region.clipAdd(x2, sg2d.transX);
        int transY2 = Region.clipAdd(y2, sg2d.transY);
        if (compClip.contains(transX1, transY1) && compClip.contains(transX2, transY2)) {
            SunToolkit.awtLock();
            try {
                this.validateSurface(sg2d);
                this.tileManager.addLine(transX1, transY1, transX2, transY2);
                this.tileManager.fillMask((XRSurfaceData)sg2d.surfaceData);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        } else {
            this.draw(sg2d, new Line2D.Float(x1, y1, x2, y2));
        }
    }

    @Override
    public void drawRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.draw(sg2d, new Rectangle2D.Float(x, y, width, height));
    }

    @Override
    public void drawPolyline(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        Path2D.Float p2d = new Path2D.Float();
        if (npoints > 1) {
            p2d.moveTo(xpoints[0], ypoints[0]);
            for (int i = 1; i < npoints; ++i) {
                p2d.lineTo(xpoints[i], ypoints[i]);
            }
        }
        this.draw(sg2d, p2d);
    }

    @Override
    public void drawPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.draw(sg2d, new Polygon(xpoints, ypoints, npoints));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        x = Region.clipAdd(x, sg2d.transX);
        y = Region.clipAdd(y, sg2d.transY);
        if (x > Short.MAX_VALUE || y > Short.MAX_VALUE) {
            return;
        }
        int x2 = Region.dimAdd(x, width);
        int y2 = Region.dimAdd(y, height);
        if (x2 < Short.MIN_VALUE || y2 < Short.MIN_VALUE) {
            return;
        }
        x = XRUtils.clampToShort(x);
        y = XRUtils.clampToShort(y);
        width = XRUtils.clampToUShort(x2 - x);
        height = XRUtils.clampToUShort(y2 - y);
        if (width == 0 || height == 0) {
            return;
        }
        SunToolkit.awtLock();
        try {
            this.validateSurface(sg2d);
            this.tileManager.addRect(x, y, width, height);
            this.tileManager.fillMask((XRSurfaceData)sg2d.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    @Override
    public void fillPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.fill(sg2d, new Polygon(xpoints, ypoints, npoints));
    }

    @Override
    public void drawRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(sg2d, new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(sg2d, new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.draw(sg2d, new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void fillOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.fill(sg2d, new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void drawArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(sg2d, new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void fillArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(sg2d, new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPath(SunGraphics2D sg2d, Path2D.Float p2df, int transx, int transy) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sg2d);
            this.drawHandler.validate(sg2d);
            ProcessPath.drawPath(this.drawHandler, p2df, transx, transy);
            this.tileManager.fillMask((XRSurfaceData)sg2d.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillPath(SunGraphics2D sg2d, Path2D.Float p2df, int transx, int transy) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sg2d);
            this.drawHandler.validate(sg2d);
            ProcessPath.fillPath(this.drawHandler, p2df, transx, transy);
            this.tileManager.fillMask((XRSurfaceData)sg2d.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillSpans(SunGraphics2D sg2d, SpanIterator si, int transx, int transy) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sg2d);
            int[] spanBox = new int[4];
            while (si.nextSpan(spanBox)) {
                this.tileManager.addRect(spanBox[0] + transx, spanBox[1] + transy, spanBox[2] - spanBox[0], spanBox[3] - spanBox[1]);
            }
            this.tileManager.fillMask((XRSurfaceData)sg2d.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sg2d, Shape s) {
        if (sg2d.strokeState == 0) {
            int transy;
            int transx;
            Path2D.Float p2df;
            if (sg2d.transformState <= 1) {
                p2df = s instanceof Path2D.Float ? (Path2D.Float)s : new Path2D.Float(s);
                transx = sg2d.transX;
                transy = sg2d.transY;
            } else {
                p2df = new Path2D.Float(s, sg2d.transform);
                transx = 0;
                transy = 0;
            }
            this.drawPath(sg2d, p2df, transx, transy);
        } else if (sg2d.strokeState < 3) {
            ShapeSpanIterator si = LoopPipe.getStrokeSpans(sg2d, s);
            try {
                this.fillSpans(sg2d, si, 0, 0);
            }
            finally {
                si.dispose();
            }
        } else {
            this.fill(sg2d, sg2d.stroke.createStrokedShape(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(SunGraphics2D sg2d, Shape s) {
        int transy;
        int transx;
        AffineTransform at;
        if (sg2d.strokeState == 0) {
            int transy2;
            int transx2;
            Path2D.Float p2df;
            if (sg2d.transformState <= 1) {
                p2df = s instanceof Path2D.Float ? (Path2D.Float)s : new Path2D.Float(s);
                transx2 = sg2d.transX;
                transy2 = sg2d.transY;
            } else {
                p2df = new Path2D.Float(s, sg2d.transform);
                transx2 = 0;
                transy2 = 0;
            }
            this.fillPath(sg2d, p2df, transx2, transy2);
            return;
        }
        if (sg2d.transformState <= 1) {
            at = null;
            transx = sg2d.transX;
            transy = sg2d.transY;
        } else {
            at = sg2d.transform;
            transy = 0;
            transx = 0;
        }
        ShapeSpanIterator ssi = LoopPipe.getFillSSI(sg2d);
        try {
            Region clip = sg2d.getCompClip();
            ssi.setOutputAreaXYXY(clip.getLoX() - transx, clip.getLoY() - transy, clip.getHiX() - transx, clip.getHiY() - transy);
            ssi.appendPath(s.getPathIterator(at));
            this.fillSpans(sg2d, ssi, transx, transy);
        }
        finally {
            ssi.dispose();
        }
    }

    private class XRDrawHandler
    extends ProcessPath.DrawHandler {
        XRDrawHandler() {
            super(0, 0, 0, 0);
        }

        void validate(SunGraphics2D sg2d) {
            Region clip = sg2d.getCompClip();
            this.setBounds(clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY(), sg2d.strokeHint);
            XRRenderer.this.validateSurface(sg2d);
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            XRRenderer.this.tileManager.addLine(x1, y1, x2, y2);
        }

        @Override
        public void drawPixel(int x, int y) {
            XRRenderer.this.tileManager.addRect(x, y, 1, 1);
        }

        @Override
        public void drawScanline(int x1, int x2, int y) {
            XRRenderer.this.tileManager.addRect(x1, y, x2 - x1 + 1, 1);
        }
    }
}

