/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XToolkitThreadBlockedHandler;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;

public class XDataTransferer
extends DataTransferer {
    static final XAtom FILE_NAME_ATOM = XAtom.get("FILE_NAME");
    static final XAtom DT_NET_FILE_ATOM = XAtom.get("_DT_NETFILE");
    static final XAtom PNG_ATOM = XAtom.get("PNG");
    static final XAtom JFIF_ATOM = XAtom.get("JFIF");
    static final XAtom TARGETS_ATOM = XAtom.get("TARGETS");
    static final XAtom INCR_ATOM = XAtom.get("INCR");
    static final XAtom MULTIPLE_ATOM = XAtom.get("MULTIPLE");
    private static XDataTransferer transferer;
    private static ImageTypeSpecifier defaultSpecifier;

    private XDataTransferer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XDataTransferer getInstanceImpl() {
        Class<XDataTransferer> clazz = XDataTransferer.class;
        synchronized (XDataTransferer.class) {
            if (transferer == null) {
                transferer = new XDataTransferer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return transferer;
        }
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "iso-10646-ucs-2";
    }

    @Override
    public boolean isLocaleDependentTextFormat(long format) {
        return false;
    }

    @Override
    public boolean isTextFormat(long format) {
        return super.isTextFormat(format) || this.isMimeFormat(format, "text");
    }

    @Override
    protected String getCharsetForTextFormat(Long lFormat) {
        long format = lFormat;
        if (this.isMimeFormat(format, "text")) {
            String nat = this.getNativeForFormat(format);
            DataFlavor df = new DataFlavor(nat, null);
            if (!DataTransferer.doesSubtypeSupportCharset(df)) {
                return null;
            }
            String charset = df.getParameter("charset");
            if (charset != null) {
                return charset;
            }
        }
        return super.getCharsetForTextFormat(lFormat);
    }

    @Override
    protected boolean isURIListFormat(long format) {
        String nat = this.getNativeForFormat(format);
        if (nat == null) {
            return false;
        }
        try {
            DataFlavor df = new DataFlavor(nat);
            if (df.getPrimaryType().equals("text") && df.getSubType().equals("uri-list")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isFileFormat(long format) {
        return format == FILE_NAME_ATOM.getAtom() || format == DT_NET_FILE_ATOM.getAtom();
    }

    @Override
    public boolean isImageFormat(long format) {
        return format == PNG_ATOM.getAtom() || format == JFIF_ATOM.getAtom() || this.isMimeFormat(format, "image");
    }

    @Override
    protected Long getFormatForNativeAsLong(String str) {
        long atom = XAtom.get(str).getAtom();
        return atom;
    }

    @Override
    protected String getNativeForFormat(long format) {
        return this.getTargetNameForAtom(format);
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return XToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
    }

    private String getTargetNameForAtom(long atom) {
        return XAtom.get(atom).getName();
    }

    @Override
    protected byte[] imageToPlatformBytes(Image image, long format) throws IOException {
        String mimeType = null;
        if (format == PNG_ATOM.getAtom()) {
            mimeType = "image/png";
        } else if (format == JFIF_ATOM.getAtom()) {
            mimeType = "image/jpeg";
        } else {
            try {
                String nat = this.getNativeForFormat(format);
                DataFlavor df = new DataFlavor(nat);
                String primaryType = df.getPrimaryType();
                if ("image".equals(primaryType)) {
                    mimeType = df.getPrimaryType() + "/" + df.getSubType();
                }
            }
            catch (Exception nat) {
                // empty catch block
            }
        }
        if (mimeType != null) {
            return this.imageToStandardBytes(image, mimeType);
        }
        String nativeFormat = this.getNativeForFormat(format);
        throw new IOException("Translation to " + nativeFormat + " is not supported.");
    }

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> fileList) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < fileList.size(); ++i) {
            byte[] bytes = fileList.get(i).getBytes();
            if (i != 0) {
                bos.write(0);
            }
            bos.write(bytes, 0, bytes.length);
        }
        return bos;
    }

    @Override
    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] bytes, long format) throws IOException {
        String mimeType = null;
        if (format == PNG_ATOM.getAtom()) {
            mimeType = "image/png";
        } else if (format == JFIF_ATOM.getAtom()) {
            mimeType = "image/jpeg";
        } else {
            try {
                String nat = this.getNativeForFormat(format);
                DataFlavor df = new DataFlavor(nat);
                String primaryType = df.getPrimaryType();
                if ("image".equals(primaryType)) {
                    mimeType = df.getPrimaryType() + "/" + df.getSubType();
                }
            }
            catch (Exception nat) {
                // empty catch block
            }
        }
        if (mimeType != null) {
            return this.standardImageBytesOrStreamToImage(inputStream, bytes, mimeType);
        }
        String nativeFormat = this.getNativeForFormat(format);
        throw new IOException("Translation from " + nativeFormat + " is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] dragQueryFile(byte[] bytes) {
        XToolkit.awtLock();
        try {
            String[] stringArray = XlibWrapper.XTextPropertyToStringList(bytes, XAtom.get("STRING").getAtom());
            return stringArray;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URI[] dragQueryURIs(InputStream stream, byte[] bytes, long format, Transferable localeTransferable) throws IOException {
        String charset = null;
        if (localeTransferable != null && this.isLocaleDependentTextFormat(format) && localeTransferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
            try {
                charset = new String((byte[])localeTransferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
        } else {
            charset = this.getCharsetForTextFormat(format);
        }
        if (charset == null) {
            charset = XDataTransferer.getDefaultTextCharset();
        }
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, charset));
            ArrayList<URI> uriList = new ArrayList<URI>();
            while ((line = reader.readLine()) != null) {
                URI uri;
                try {
                    uri = new URI(line);
                }
                catch (URISyntaxException uriSyntaxException) {
                    throw new IOException(uriSyntaxException);
                }
                uriList.add(uri);
            }
            URI[] uRIArray = uriList.toArray(new URI[uriList.size()]);
            return uRIArray;
        }
    }

    private boolean isMimeFormat(long format, String primaryType) {
        String nat = this.getNativeForFormat(format);
        if (nat == null) {
            return false;
        }
        try {
            DataFlavor df = new DataFlavor(nat);
            if (primaryType.equals(df.getPrimaryType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List getPlatformMappingsForNative(String nat) {
        Iterator<ImageReader> readers;
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        if (nat == null) {
            return flavors;
        }
        DataFlavor df = null;
        try {
            df = new DataFlavor(nat);
        }
        catch (Exception e) {
            return flavors;
        }
        Object value = df;
        String primaryType = df.getPrimaryType();
        String baseType = primaryType + "/" + df.getSubType();
        if ("text".equals(primaryType)) {
            value = primaryType + "/" + df.getSubType();
        } else if ("image".equals(primaryType) && (readers = ImageIO.getImageReadersByMIMEType(baseType)).hasNext()) {
            flavors.add(DataFlavor.imageFlavor);
        }
        flavors.add((DataFlavor)value);
        return flavors;
    }

    private ImageTypeSpecifier getDefaultImageTypeSpecifier() {
        if (defaultSpecifier == null) {
            ColorModel model = ColorModel.getRGBdefault();
            WritableRaster raster = model.createCompatibleWritableRaster(10, 10);
            BufferedImage bufferedImage = new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
            defaultSpecifier = new ImageTypeSpecifier(bufferedImage);
        }
        return defaultSpecifier;
    }

    @Override
    public List getPlatformMappingsForFlavor(DataFlavor df) {
        String baseType;
        ArrayList<String> natives = new ArrayList<String>(1);
        if (df == null) {
            return natives;
        }
        String charset = df.getParameter("charset");
        String mimeType = baseType = df.getPrimaryType() + "/" + df.getSubType();
        if (charset != null && DataTransferer.isFlavorCharsetTextType(df)) {
            mimeType = mimeType + ";charset=" + charset;
        }
        if (df.getRepresentationClass() != null && (df.isRepresentationClassInputStream() || df.isRepresentationClassByteBuffer() || byteArrayClass.equals(df.getRepresentationClass()))) {
            natives.add(mimeType);
        }
        if (DataFlavor.imageFlavor.equals(df)) {
            String[] mimeTypes = ImageIO.getWriterMIMETypes();
            if (mimeTypes != null) {
                block0: for (int i = 0; i < mimeTypes.length; ++i) {
                    Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeTypes[i]);
                    while (writers.hasNext()) {
                        ImageWriter imageWriter = writers.next();
                        ImageWriterSpi writerSpi = imageWriter.getOriginatingProvider();
                        if (writerSpi == null || !writerSpi.canEncodeImage(this.getDefaultImageTypeSpecifier())) continue;
                        natives.add(mimeTypes[i]);
                        continue block0;
                    }
                }
            }
        } else if (DataTransferer.isFlavorCharsetTextType(df)) {
            Iterator iter = DataTransferer.standardEncodings();
            if (DataFlavor.stringFlavor.equals(df)) {
                baseType = "text/plain";
            }
            while (iter.hasNext()) {
                String encoding = (String)iter.next();
                if (encoding.equals(charset)) continue;
                natives.add(baseType + ";charset=" + encoding);
            }
            if (!natives.contains(baseType)) {
                natives.add(baseType);
            }
        }
        return natives;
    }

    static {
        defaultSpecifier = null;
    }
}

