/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.CRC;
import java.io.IOException;
import java.util.zip.Deflater;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

final class IDATOutputStream
extends ImageOutputStreamImpl {
    private static byte[] chunkType = new byte[]{73, 68, 65, 84};
    private ImageOutputStream stream;
    private int chunkLength;
    private long startPos;
    private CRC crc = new CRC();
    Deflater def = new Deflater(9);
    byte[] buf = new byte[512];
    private int bytesRemaining;

    public IDATOutputStream(ImageOutputStream stream, int chunkLength) throws IOException {
        this.stream = stream;
        this.chunkLength = chunkLength;
        this.startChunk();
    }

    private void startChunk() throws IOException {
        this.crc.reset();
        this.startPos = this.stream.getStreamPosition();
        this.stream.writeInt(-1);
        this.crc.update(chunkType, 0, 4);
        this.stream.write(chunkType, 0, 4);
        this.bytesRemaining = this.chunkLength;
    }

    private void finishChunk() throws IOException {
        this.stream.writeInt(this.crc.getValue());
        long pos = this.stream.getStreamPosition();
        this.stream.seek(this.startPos);
        this.stream.writeInt((int)(pos - this.startPos) - 12);
        this.stream.seek(pos);
        this.stream.flushBefore(pos);
    }

    @Override
    public int read() throws IOException {
        throw new RuntimeException("Method not available");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new RuntimeException("Method not available");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(b, off, len);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        int off = 0;
        while (len > 0) {
            if (this.bytesRemaining == 0) {
                this.finishChunk();
                this.startChunk();
            }
            int nbytes = Math.min(len, this.bytesRemaining);
            this.crc.update(this.buf, off, nbytes);
            this.stream.write(this.buf, off, nbytes);
            off += nbytes;
            len -= nbytes;
            this.bytesRemaining -= nbytes;
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] wbuf = new byte[]{(byte)b};
        this.write(wbuf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            if (!this.def.finished()) {
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
            }
            this.finishChunk();
        }
        finally {
            this.def.end();
        }
    }

    @Override
    protected void finalize() throws Throwable {
    }
}

