/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.policy;

import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.policy.SelectionPolicy;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputModeSelectionPolicy
implements SelectionPolicy<ParamConfig.InputMode> {
    public ParamConfig.InputMode select(Properties properties, ParamConfig.InputMode ... options) {
        ParamConfig.InputMode retVal = options[0];
        for (ParamConfig.InputMode option : options) {
            retVal = InputModeSelectionPolicy.decide(properties, retVal, option);
        }
        return retVal;
    }

    public ParamConfig.InputMode select(ParamConfig.InputMode ... options) {
        return this.select((Properties)null, options);
    }

    private static ParamConfig.InputMode decide(Properties properties, ParamConfig.InputMode option1, ParamConfig.InputMode option2) {
        switch (option1) {
            case NONE: {
                return option2;
            }
            case USER: {
                return option1;
            }
            case ENV_VAR: {
                return option2 == ParamConfig.InputMode.USER ? option2 : option1;
            }
            case DEFAULT: {
                return option2 == ParamConfig.InputMode.ENV_VAR || option2 == ParamConfig.InputMode.USER ? option2 : option1;
            }
        }
        throw new InternalErrorException("BUG: probably a new InputMode added to InputMode without updating this option");
    }
}

