/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.validators;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.validators.ParamValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedLongParamValidator
implements ParamValidator<Long> {
    @Override
    public Long validate(String param) throws CliCommandoException {
        Long number;
        try {
            number = Long.valueOf(param);
            if (number < 0L) {
                throw new BadInputException(ErrorMessages.ErrorCode.NEGATIVE_VALUE, param);
            }
        }
        catch (NumberFormatException nfe) {
            throw new BadInputException(ErrorMessages.ErrorCode.NOT_NUMBER, param);
        }
        return number;
    }
}

