/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import sun.misc.Timer;
import sun.misc.TimerTickThread;

class TimerThread
extends Thread {
    public static boolean debug = false;
    static TimerThread timerThread;
    static boolean notified;
    static Timer timerQueue;

    protected TimerThread() {
        super("TimerThread");
        timerThread = this;
        this.start();
    }

    @Override
    public synchronized void run() {
        while (true) {
            if (timerQueue == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            notified = false;
            long delay = TimerThread.timerQueue.sleepUntil - System.currentTimeMillis();
            if (delay > 0L) {
                try {
                    this.wait(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (notified) continue;
            Timer timer = timerQueue;
            timerQueue = TimerThread.timerQueue.next;
            TimerTickThread thr = TimerTickThread.call(timer, timer.sleepUntil);
            if (!debug) continue;
            long delta = System.currentTimeMillis() - timer.sleepUntil;
            System.out.println("tick(" + thr.getName() + "," + timer.interval + "," + delta + ")");
            if (delta <= 250L) continue;
            System.out.println("*** BIG DELAY ***");
        }
    }

    protected static void enqueue(Timer timer) {
        Timer prev = null;
        Timer cur = timerQueue;
        if (cur == null || timer.sleepUntil <= cur.sleepUntil) {
            timer.next = timerQueue;
            timerQueue = timer;
            notified = true;
            timerThread.notify();
        } else {
            do {
                prev = cur;
            } while ((cur = cur.next) != null && timer.sleepUntil > cur.sleepUntil);
            timer.next = cur;
            prev.next = timer;
        }
        if (debug) {
            long now = System.currentTimeMillis();
            System.out.print(Thread.currentThread().getName() + ": enqueue " + timer.interval + ": ");
            cur = timerQueue;
            while (cur != null) {
                long delta = cur.sleepUntil - now;
                System.out.print(cur.interval + "(" + delta + ") ");
                cur = cur.next;
            }
            System.out.println();
        }
    }

    protected static boolean dequeue(Timer timer) {
        Timer prev = null;
        Timer cur = timerQueue;
        while (cur != null && cur != timer) {
            prev = cur;
            cur = cur.next;
        }
        if (cur == null) {
            if (debug) {
                System.out.println(Thread.currentThread().getName() + ": dequeue " + timer.interval + ": no-op");
            }
            return false;
        }
        if (prev == null) {
            timerQueue = timer.next;
            notified = true;
            timerThread.notify();
        } else {
            prev.next = timer.next;
        }
        timer.next = null;
        if (debug) {
            long now = System.currentTimeMillis();
            System.out.print(Thread.currentThread().getName() + ": dequeue " + timer.interval + ": ");
            cur = timerQueue;
            while (cur != null) {
                long delta = cur.sleepUntil - now;
                System.out.print(cur.interval + "(" + delta + ") ");
                cur = cur.next;
            }
            System.out.println();
        }
        return true;
    }

    protected static void requeue(Timer timer) {
        if (!timer.stopped) {
            long now = System.currentTimeMillis();
            timer.sleepUntil = timer.regular ? (timer.sleepUntil += timer.interval) : now + timer.interval;
            TimerThread.enqueue(timer);
        } else if (debug) {
            System.out.println(Thread.currentThread().getName() + ": requeue " + timer.interval + ": no-op");
        }
    }

    static {
        notified = false;
        timerQueue = null;
    }
}

