/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsUrl;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import sun.net.dns.ResolverConfiguration;

public class DnsContextFactory
implements InitialContextFactory {
    private static final String DEFAULT_URL = "dns:";
    private static final int DEFAULT_PORT = 53;

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        if (env == null) {
            env = new Hashtable(5);
        }
        return DnsContextFactory.urlToContext(DnsContextFactory.getInitCtxUrl(env), env);
    }

    public static DnsContext getContext(String domain, String[] servers, Hashtable<?, ?> env) throws NamingException {
        return new DnsContext(domain, servers, env);
    }

    public static DnsContext getContext(String domain, DnsUrl[] urls, Hashtable<?, ?> env) throws NamingException {
        String[] servers = DnsContextFactory.serversForUrls(urls);
        DnsContext ctx = DnsContextFactory.getContext(domain, servers, env);
        if (DnsContextFactory.platformServersUsed(urls)) {
            ctx.setProviderUrl(DnsContextFactory.constructProviderUrl(domain, servers));
        }
        return ctx;
    }

    public static boolean platformServersAvailable() {
        return !DnsContextFactory.filterNameServers(ResolverConfiguration.open().nameservers(), true).isEmpty();
    }

    private static Context urlToContext(String url, Hashtable<?, ?> env) throws NamingException {
        DnsUrl[] urls;
        try {
            urls = DnsUrl.fromList(url);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e.getMessage());
        }
        if (urls.length == 0) {
            throw new ConfigurationException("Invalid DNS pseudo-URL(s): " + url);
        }
        String domain = urls[0].getDomain();
        for (int i = 1; i < urls.length; ++i) {
            if (domain.equalsIgnoreCase(urls[i].getDomain())) continue;
            throw new ConfigurationException("Conflicting domains: " + url);
        }
        return DnsContextFactory.getContext(domain, urls, env);
    }

    private static String[] serversForUrls(DnsUrl[] urls) throws NamingException {
        if (urls.length == 0) {
            throw new ConfigurationException("DNS pseudo-URL required");
        }
        ArrayList<String> servers = new ArrayList<String>();
        for (int i = 0; i < urls.length; ++i) {
            List<String> platformServers;
            String server = urls[i].getHost();
            int port = urls[i].getPort();
            if (server == null && port < 0 && !(platformServers = DnsContextFactory.filterNameServers(ResolverConfiguration.open().nameservers(), false)).isEmpty()) {
                servers.addAll(platformServers);
                continue;
            }
            if (server == null) {
                server = "localhost";
            }
            servers.add(port < 0 ? server : server + ":" + port);
        }
        return servers.toArray(new String[servers.size()]);
    }

    private static boolean platformServersUsed(DnsUrl[] urls) {
        if (!DnsContextFactory.platformServersAvailable()) {
            return false;
        }
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i].getHost() != null || urls[i].getPort() >= 0) continue;
            return true;
        }
        return false;
    }

    private static String constructProviderUrl(String domain, String[] servers) {
        String path = "";
        if (!domain.equals(".")) {
            try {
                path = "/" + UrlUtil.encode(domain, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < servers.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append("dns://").append(servers[i]).append(path);
        }
        return buf.toString();
    }

    private static String getInitCtxUrl(Hashtable<?, ?> env) {
        String url = (String)env.get("java.naming.provider.url");
        return url != null ? url : DEFAULT_URL;
    }

    private static List<String> filterNameServers(List<String> input, boolean oneIsEnough) {
        SecurityManager security = System.getSecurityManager();
        if (security == null || input == null || input.isEmpty()) {
            return input;
        }
        ArrayList<String> output = new ArrayList<String>();
        for (String platformServer : input) {
            int colon = platformServer.indexOf(58, platformServer.indexOf(93) + 1);
            int p = colon < 0 ? 53 : Integer.parseInt(platformServer.substring(colon + 1));
            String s = colon < 0 ? platformServer : platformServer.substring(0, colon);
            try {
                security.checkConnect(s, p);
                output.add(platformServer);
                if (!oneIsEnough) continue;
                return output;
            }
            catch (SecurityException se) {
            }
        }
        return output;
    }
}

