/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.GetServerID;
import com.sun.corba.se.impl.activation.Help;
import com.sun.corba.se.impl.activation.ListActiveServers;
import com.sun.corba.se.impl.activation.ListAliases;
import com.sun.corba.se.impl.activation.ListORBs;
import com.sun.corba.se.impl.activation.ListServers;
import com.sun.corba.se.impl.activation.LocateServer;
import com.sun.corba.se.impl.activation.LocateServerForORB;
import com.sun.corba.se.impl.activation.Quit;
import com.sun.corba.se.impl.activation.RegisterServer;
import com.sun.corba.se.impl.activation.ShutdownServer;
import com.sun.corba.se.impl.activation.StartServer;
import com.sun.corba.se.impl.activation.UnRegisterServer;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.ORB;

public class ServerTool {
    static final String helpCommand = "help";
    static final String toolName = "servertool";
    static final String commandArg = "-cmd";
    private static final boolean debug = false;
    ORB orb = null;
    static Vector handlers = new Vector();
    static int maxNameLen;

    static int getServerIdForAlias(ORB orb, String applicationName) throws ServerNotRegistered {
        try {
            Repository rep = RepositoryHelper.narrow(orb.resolve_initial_references("ServerRepository"));
            int serverid = rep.getServerID(applicationName);
            return rep.getServerID(applicationName);
        }
        catch (Exception ex) {
            throw new ServerNotRegistered();
        }
    }

    void run(String[] args) {
        block7: {
            String[] cmd = null;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals(commandArg)) continue;
                int cmdLen = args.length - i - 1;
                cmd = new String[cmdLen];
                for (int j = 0; j < cmdLen; ++j) {
                    cmd[j] = args[++i];
                }
                break;
            }
            try {
                Properties props = System.getProperties();
                props.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.impl.orb.ORBImpl");
                this.orb = ORB.init(args, props);
                if (cmd != null) {
                    this.executeCommand(cmd);
                    break block7;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                System.out.println(CorbaResourceUtil.getText("servertool.banner"));
                while (true) {
                    if ((cmd = this.readCommand(in)) != null) {
                        this.executeCommand(cmd);
                        continue;
                    }
                    this.printAvailableCommands();
                }
            }
            catch (Exception ex) {
                System.out.println(CorbaResourceUtil.getText("servertool.usage", toolName));
                System.out.println();
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        ServerTool tool = new ServerTool();
        tool.run(args);
    }

    String[] readCommand(BufferedReader in) {
        System.out.print("servertool > ");
        try {
            StringTokenizer st;
            int i = 0;
            String[] cmd = null;
            String cmdLine = in.readLine();
            if (cmdLine != null && (st = new StringTokenizer(cmdLine)).countTokens() != 0) {
                cmd = new String[st.countTokens()];
                while (st.hasMoreTokens()) {
                    cmd[i++] = st.nextToken();
                }
            }
            return cmd;
        }
        catch (Exception ex) {
            System.out.println(CorbaResourceUtil.getText("servertool.usage", toolName));
            System.out.println();
            ex.printStackTrace();
            return null;
        }
    }

    void printAvailableCommands() {
        System.out.println(CorbaResourceUtil.getText("servertool.shorthelp"));
        for (int i = 0; i < handlers.size(); ++i) {
            CommandHandler handler = (CommandHandler)handlers.elementAt(i);
            System.out.print("\t" + handler.getCommandName());
            for (int j = handler.getCommandName().length(); j < maxNameLen; ++j) {
                System.out.print(" ");
            }
            System.out.print(" - ");
            handler.printCommandHelp(System.out, true);
        }
        System.out.println();
    }

    void executeCommand(String[] cmd) {
        if (cmd[0].equals(helpCommand)) {
            if (cmd.length == 1) {
                this.printAvailableCommands();
            } else {
                for (int i = 0; i < handlers.size(); ++i) {
                    CommandHandler handler = (CommandHandler)handlers.elementAt(i);
                    if (!handler.getCommandName().equals(cmd[1])) continue;
                    handler.printCommandHelp(System.out, false);
                }
            }
            return;
        }
        for (int i = 0; i < handlers.size(); ++i) {
            CommandHandler handler = (CommandHandler)handlers.elementAt(i);
            if (!handler.getCommandName().equals(cmd[0])) continue;
            String[] cmdArgs = new String[cmd.length - 1];
            for (int j = 0; j < cmdArgs.length; ++j) {
                cmdArgs[j] = cmd[j + 1];
            }
            try {
                System.out.println();
                boolean result = handler.processCommand(cmdArgs, this.orb, System.out);
                if (result) {
                    handler.printCommandHelp(System.out, false);
                }
                System.out.println();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.printAvailableCommands();
    }

    static {
        handlers.addElement(new RegisterServer());
        handlers.addElement(new UnRegisterServer());
        handlers.addElement(new GetServerID());
        handlers.addElement(new ListServers());
        handlers.addElement(new ListAliases());
        handlers.addElement(new ListActiveServers());
        handlers.addElement(new LocateServer());
        handlers.addElement(new LocateServerForORB());
        handlers.addElement(new ListORBs());
        handlers.addElement(new ShutdownServer());
        handlers.addElement(new StartServer());
        handlers.addElement(new Help());
        handlers.addElement(new Quit());
        maxNameLen = 0;
        for (int i = 0; i < handlers.size(); ++i) {
            CommandHandler handler = (CommandHandler)handlers.elementAt(i);
            int cmdNameLen = handler.getCommandName().length();
            if (cmdNameLen <= maxNameLen) continue;
            maxNameLen = cmdNameLen;
        }
    }
}

