/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.ctx;

import com.sun.jndi.toolkit.ctx.AtomicContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.PartialCompositeContext;
import com.sun.jndi.toolkit.ctx.StringHeadTail;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;

public abstract class PartialCompositeDirContext
extends AtomicContext
implements DirContext {
    protected PartialCompositeDirContext() {
        this._contextType = 1;
    }

    protected abstract Attributes p_getAttributes(Name var1, String[] var2, Continuation var3) throws NamingException;

    protected abstract void p_modifyAttributes(Name var1, int var2, Attributes var3, Continuation var4) throws NamingException;

    protected abstract void p_modifyAttributes(Name var1, ModificationItem[] var2, Continuation var3) throws NamingException;

    protected abstract void p_bind(Name var1, Object var2, Attributes var3, Continuation var4) throws NamingException;

    protected abstract void p_rebind(Name var1, Object var2, Attributes var3, Continuation var4) throws NamingException;

    protected abstract DirContext p_createSubcontext(Name var1, Attributes var2, Continuation var3) throws NamingException;

    protected abstract NamingEnumeration<SearchResult> p_search(Name var1, Attributes var2, String[] var3, Continuation var4) throws NamingException;

    protected abstract NamingEnumeration<SearchResult> p_search(Name var1, String var2, SearchControls var3, Continuation var4) throws NamingException;

    protected abstract NamingEnumeration<SearchResult> p_search(Name var1, String var2, Object[] var3, SearchControls var4, Continuation var5) throws NamingException;

    protected abstract DirContext p_getSchema(Name var1, Continuation var2) throws NamingException;

    protected abstract DirContext p_getSchemaClassDefinition(Name var1, Continuation var2) throws NamingException;

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new CompositeName(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Attributes answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_getAttributes(nm, attrIds, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_getAttributes(nm, attrIds, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.getAttributes(e.getRemainingName(), attrIds);
        }
        return answer;
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(new CompositeName(name), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            ctx.p_modifyAttributes(nm, mod_op, attrs, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                ctx.p_modifyAttributes(nm, mod_op, attrs, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            cctx.modifyAttributes(e.getRemainingName(), mod_op, attrs);
        }
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(new CompositeName(name), mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            ctx.p_modifyAttributes(nm, mods, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                ctx.p_modifyAttributes(nm, mods, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            cctx.modifyAttributes(e.getRemainingName(), mods);
        }
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(new CompositeName(name), obj, attrs);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            ctx.p_bind(nm, obj, attrs, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                ctx.p_bind(nm, obj, attrs, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            cctx.bind(e.getRemainingName(), obj, attrs);
        }
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(new CompositeName(name), obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            ctx.p_rebind(nm, obj, attrs, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                ctx.p_rebind(nm, obj, attrs, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            cctx.rebind(e.getRemainingName(), obj, attrs);
        }
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext(new CompositeName(name), attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        DirContext answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_createSubcontext(nm, attrs, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_createSubcontext(nm, attrs, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.createSubcontext(e.getRemainingName(), attrs);
        }
        return answer;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search((Name)new CompositeName(name), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        NamingEnumeration<SearchResult> answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_search(nm, matchingAttributes, attributesToReturn, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_search(nm, matchingAttributes, attributesToReturn, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.search(e.getRemainingName(), matchingAttributes, attributesToReturn);
        }
        return answer;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new CompositeName(name), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        NamingEnumeration<SearchResult> answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_search(nm, filter, cons, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_search(nm, filter, cons, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.search(e.getRemainingName(), filter, cons);
        }
        return answer;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(new CompositeName(name), filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        NamingEnumeration<SearchResult> answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_search(nm, filterExpr, filterArgs, cons, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_search(nm, filterExpr, filterArgs, cons, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.search(e.getRemainingName(), filterExpr, filterArgs, cons);
        }
        return answer;
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.getSchema(new CompositeName(name));
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        DirContext answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_getSchema(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_getSchema(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.getSchema(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.getSchemaClassDefinition(new CompositeName(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        DirContext answer;
        PartialCompositeDirContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_getSchemaClassDefinition(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeDirContext.getPCDirContext(cont);
                answer = ctx.p_getSchemaClassDefinition(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            DirContext cctx = DirectoryManager.getContinuationDirContext(e);
            answer = cctx.getSchemaClassDefinition(e.getRemainingName());
        }
        return answer;
    }

    protected static PartialCompositeDirContext getPCDirContext(Continuation cont) throws NamingException {
        PartialCompositeContext pctx = PartialCompositeContext.getPCContext(cont);
        if (!(pctx instanceof PartialCompositeDirContext)) {
            throw cont.fillInException(new NotContextException("Resolved object is not a DirContext."));
        }
        return (PartialCompositeDirContext)pctx;
    }

    @Override
    protected StringHeadTail c_parseComponent(String inputName, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected Object a_lookup(String name, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected Object a_lookupLink(String name, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected NamingEnumeration<NameClassPair> a_list(Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected NamingEnumeration<Binding> a_listBindings(Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected void a_bind(String name, Object obj, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected void a_rebind(String name, Object obj, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected void a_unbind(String name, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected void a_destroySubcontext(String name, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected Context a_createSubcontext(String name, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected void a_rename(String oldname, Name newname, Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }

    @Override
    protected NameParser a_getNameParser(Continuation cont) throws NamingException {
        OperationNotSupportedException e = new OperationNotSupportedException();
        throw cont.fillInException(e);
    }
}

