/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.IOException;
import java.io.OutputStream;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.util.KrbDataOutputStream;

public class CCacheOutputStream
extends KrbDataOutputStream
implements FileCCacheConstants {
    public CCacheOutputStream(OutputStream os) {
        super(os);
    }

    public void writeHeader(PrincipalName p, int version) throws IOException {
        this.write((version & 0xFF00) >> 8);
        this.write(version & 0xFF);
        p.writePrincipal(this);
    }

    public void addCreds(Credentials creds) throws IOException, Asn1Exception {
        creds.cname.writePrincipal(this);
        creds.sname.writePrincipal(this);
        creds.key.writeKey(this);
        this.write32((int)(creds.authtime.getTime() / 1000L));
        if (creds.starttime != null) {
            this.write32((int)(creds.starttime.getTime() / 1000L));
        } else {
            this.write32(0);
        }
        this.write32((int)(creds.endtime.getTime() / 1000L));
        if (creds.renewTill != null) {
            this.write32((int)(creds.renewTill.getTime() / 1000L));
        } else {
            this.write32(0);
        }
        if (creds.isEncInSKey) {
            this.write8(1);
        } else {
            this.write8(0);
        }
        this.writeFlags(creds.flags);
        if (creds.caddr == null) {
            this.write32(0);
        } else {
            creds.caddr.writeAddrs(this);
        }
        if (creds.authorizationData == null) {
            this.write32(0);
        } else {
            creds.authorizationData.writeAuth(this);
        }
        this.writeTicket(creds.ticket);
        this.writeTicket(creds.secondTicket);
    }

    void writeTicket(Ticket t) throws IOException, Asn1Exception {
        if (t == null) {
            this.write32(0);
        } else {
            byte[] bytes = t.asn1Encode();
            this.write32(bytes.length);
            this.write(bytes, 0, bytes.length);
        }
    }

    void writeFlags(TicketFlags flags) throws IOException {
        int tFlags = 0;
        boolean[] f = flags.toBooleanArray();
        if (f[1]) {
            tFlags |= 0x40000000;
        }
        if (f[2]) {
            tFlags |= 0x20000000;
        }
        if (f[3]) {
            tFlags |= 0x10000000;
        }
        if (f[4]) {
            tFlags |= 0x8000000;
        }
        if (f[5]) {
            tFlags |= 0x4000000;
        }
        if (f[6]) {
            tFlags |= 0x2000000;
        }
        if (f[7]) {
            tFlags |= 0x1000000;
        }
        if (f[8]) {
            tFlags |= 0x800000;
        }
        if (f[9]) {
            tFlags |= 0x400000;
        }
        if (f[10]) {
            tFlags |= 0x200000;
        }
        if (f[11]) {
            tFlags |= 0x100000;
        }
        this.write32(tFlags);
    }
}

