/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.ServiceLocator;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public final class LdapCtxFactory
implements ObjectFactory,
InitialContextFactory {
    public static final String ADDRESS_TYPE = "URL";

    @Override
    public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        if (!LdapCtxFactory.isLdapRef(ref)) {
            return null;
        }
        ldapURLContextFactory factory = new ldapURLContextFactory();
        String[] urls = LdapCtxFactory.getURLs((Reference)ref);
        return factory.getObjectInstance(urls, name, nameCtx, env);
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> envprops) throws NamingException {
        try {
            String providerUrl;
            String string = providerUrl = envprops != null ? (String)envprops.get("java.naming.provider.url") : null;
            if (providerUrl == null) {
                return new LdapCtx("", "localhost", 389, envprops, false);
            }
            String[] urls = LdapURL.fromList(providerUrl);
            if (urls.length == 0) {
                throw new ConfigurationException("java.naming.provider.url property does not contain a URL");
            }
            return LdapCtxFactory.getLdapCtxInstance(urls, envprops);
        }
        catch (LdapReferralException e) {
            if (envprops != null && "throw".equals(envprops.get("java.naming.referral"))) {
                throw e;
            }
            Control[] bindCtls = envprops != null ? (Control[])envprops.get("java.naming.ldap.control.connect") : null;
            return (LdapCtx)e.getReferralContext(envprops, bindCtls);
        }
    }

    private static boolean isLdapRef(Object obj) {
        if (!(obj instanceof Reference)) {
            return false;
        }
        String thisClassName = LdapCtxFactory.class.getName();
        Reference ref = (Reference)obj;
        return thisClassName.equals(ref.getFactoryClassName());
    }

    private static String[] getURLs(Reference ref) throws NamingException {
        int size = 0;
        String[] urls = new String[ref.size()];
        Enumeration<RefAddr> addrs = ref.getAll();
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            if (!(addr instanceof StringRefAddr) || !addr.getType().equals(ADDRESS_TYPE)) continue;
            urls[size++] = (String)addr.getContent();
        }
        if (size == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (size == ref.size()) {
            return urls;
        }
        String[] urls2 = new String[size];
        System.arraycopy(urls, 0, urls2, 0, size);
        return urls2;
    }

    public static DirContext getLdapCtxInstance(Object urlInfo, Hashtable<?, ?> env) throws NamingException {
        if (urlInfo instanceof String) {
            return LdapCtxFactory.getUsingURL((String)urlInfo, env);
        }
        if (urlInfo instanceof String[]) {
            return LdapCtxFactory.getUsingURLs((String[])urlInfo, env);
        }
        throw new IllegalArgumentException("argument must be an LDAP URL String or array of them");
    }

    private static DirContext getUsingURL(String url, Hashtable<?, ?> env) throws NamingException {
        String[] hostports;
        DirContext ctx = null;
        LdapURL ldapUrl = new LdapURL(url);
        String dn = ldapUrl.getDN();
        String host = ldapUrl.getHost();
        int port = ldapUrl.getPort();
        String domainName = null;
        if (host == null && port == -1 && dn != null && (domainName = ServiceLocator.mapDnToDomainName(dn)) != null && (hostports = ServiceLocator.getLdapService(domainName, env)) != null) {
            String scheme = ldapUrl.getScheme() + "://";
            String[] newUrls = new String[hostports.length];
            String query = ldapUrl.getQuery();
            String urlSuffix = ldapUrl.getPath() + (query != null ? query : "");
            for (int i = 0; i < hostports.length; ++i) {
                newUrls[i] = scheme + hostports[i] + urlSuffix;
            }
            ctx = LdapCtxFactory.getUsingURLs(newUrls, env);
            ((LdapCtx)ctx).setDomainName(domainName);
        } else {
            ctx = new LdapCtx(dn, host, port, env, ldapUrl.useSsl());
            ((LdapCtx)ctx).setProviderUrl(url);
        }
        return ctx;
    }

    private static DirContext getUsingURLs(String[] urls, Hashtable<?, ?> env) throws NamingException {
        NamingException ne = null;
        Object ctx = null;
        for (int i = 0; i < urls.length; ++i) {
            try {
                return LdapCtxFactory.getUsingURL(urls[i], env);
            }
            catch (AuthenticationException e) {
                throw e;
            }
            catch (NamingException e) {
                ne = e;
                continue;
            }
        }
        throw ne;
    }

    public static Attribute createTypeNameAttr(Class<?> cl) {
        Vector<String> v = new Vector<String>(10);
        String[] types = LdapCtxFactory.getTypeNames(cl, v);
        if (types.length > 0) {
            BasicAttribute tAttr = new BasicAttribute(Obj.JAVA_ATTRIBUTES[6]);
            for (int i = 0; i < types.length; ++i) {
                tAttr.add(types[i]);
            }
            return tAttr;
        }
        return null;
    }

    private static String[] getTypeNames(Class<?> currentClass, Vector<String> v) {
        LdapCtxFactory.getClassesAux(currentClass, v);
        Class<?>[] members = currentClass.getInterfaces();
        for (int i = 0; i < members.length; ++i) {
            LdapCtxFactory.getClassesAux(members[i], v);
        }
        String[] ret = new String[v.size()];
        int i = 0;
        for (String name : v) {
            ret[i++] = name;
        }
        return ret;
    }

    private static void getClassesAux(Class<?> currentClass, Vector<String> v) {
        if (!v.contains(currentClass.getName())) {
            v.addElement(currentClass.getName());
        }
        for (currentClass = currentClass.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            LdapCtxFactory.getTypeNames(currentClass, v);
        }
    }
}

