/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.keyinfo;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import sun.security.jca.GetInstance;

public abstract class KeyInfoFactory {
    private String mechanismType;
    private Provider provider;

    protected KeyInfoFactory() {
    }

    public static KeyInfoFactory getInstance(String mechanismType) {
        GetInstance.Instance instance;
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        try {
            instance = GetInstance.getInstance("KeyInfoFactory", null, mechanismType);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchMechanismException(nsae);
        }
        KeyInfoFactory factory = (KeyInfoFactory)instance.impl;
        factory.mechanismType = mechanismType;
        factory.provider = instance.provider;
        return factory;
    }

    public static KeyInfoFactory getInstance(String mechanismType, Provider provider) {
        GetInstance.Instance instance;
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        try {
            instance = GetInstance.getInstance("KeyInfoFactory", null, mechanismType, provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchMechanismException(nsae);
        }
        KeyInfoFactory factory = (KeyInfoFactory)instance.impl;
        factory.mechanismType = mechanismType;
        factory.provider = instance.provider;
        return factory;
    }

    public static KeyInfoFactory getInstance(String mechanismType, String provider) throws NoSuchProviderException {
        GetInstance.Instance instance;
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        if (provider.length() == 0) {
            throw new NoSuchProviderException();
        }
        try {
            instance = GetInstance.getInstance("KeyInfoFactory", null, mechanismType, provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchMechanismException(nsae);
        }
        KeyInfoFactory factory = (KeyInfoFactory)instance.impl;
        factory.mechanismType = mechanismType;
        factory.provider = instance.provider;
        return factory;
    }

    public static KeyInfoFactory getInstance() {
        return KeyInfoFactory.getInstance("DOM");
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract KeyInfo newKeyInfo(List var1);

    public abstract KeyInfo newKeyInfo(List var1, String var2);

    public abstract KeyName newKeyName(String var1);

    public abstract KeyValue newKeyValue(PublicKey var1) throws KeyException;

    public abstract PGPData newPGPData(byte[] var1);

    public abstract PGPData newPGPData(byte[] var1, byte[] var2, List var3);

    public abstract PGPData newPGPData(byte[] var1, List var2);

    public abstract RetrievalMethod newRetrievalMethod(String var1);

    public abstract RetrievalMethod newRetrievalMethod(String var1, String var2, List var3);

    public abstract X509Data newX509Data(List var1);

    public abstract X509IssuerSerial newX509IssuerSerial(String var1, BigInteger var2);

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    public abstract KeyInfo unmarshalKeyInfo(XMLStructure var1) throws MarshalException;
}

