/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;

class NameGenerator {
    private Map valueToName = new IdentityHashMap();
    private Map nameToCount = new HashMap();

    public void clear() {
        this.valueToName.clear();
        this.nameToCount.clear();
    }

    public static String unqualifiedClassName(Class type) {
        if (type.isArray()) {
            return NameGenerator.unqualifiedClassName(type.getComponentType()) + "Array";
        }
        String name = type.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public String instanceName(Object instance) {
        if (instance == null) {
            return "null";
        }
        if (instance instanceof Class) {
            return NameGenerator.unqualifiedClassName((Class)instance);
        }
        String result = (String)this.valueToName.get(instance);
        if (result != null) {
            return result;
        }
        Class<?> type = instance.getClass();
        String className = NameGenerator.unqualifiedClassName(type);
        Object size = this.nameToCount.get(className);
        int instanceNumber = size == null ? 0 : (Integer)size + 1;
        this.nameToCount.put(className, new Integer(instanceNumber));
        result = className + instanceNumber;
        this.valueToName.put(instance, result);
        return result;
    }
}

