/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

@Deprecated
class PolicyParser {
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private Vector<GrantEntry> grantEntries = new Vector();
    private static final Debug debug = Debug.getInstance("parser", "\t[Auth Policy Parser]");
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private boolean expandProp = false;
    private String keyStoreUrlString = null;
    private String keyStoreType = null;

    private String expand(String value) throws PropertyExpander.ExpandException {
        if (this.expandProp) {
            return PropertyExpander.expand(value);
        }
        return value;
    }

    public PolicyParser() {
    }

    public PolicyParser(boolean expandProp) {
        this();
        this.expandProp = expandProp;
    }

    public void read(Reader policy) throws ParsingException, IOException {
        if (!(policy instanceof BufferedReader)) {
            policy = new BufferedReader(policy);
        }
        this.st = new StreamTokenizer(policy);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                GrantEntry ge = this.parseGrantEntry();
                if (ge != null) {
                    this.add(ge);
                }
            } else if (this.peek("keystore") && this.keyStoreUrlString == null) {
                this.parseKeyStoreEntry();
            }
            this.match(";");
        }
    }

    public void add(GrantEntry ge) {
        this.grantEntries.addElement(ge);
    }

    public void replace(GrantEntry origGe, GrantEntry newGe) {
        this.grantEntries.setElementAt(newGe, this.grantEntries.indexOf(origGe));
    }

    public boolean remove(GrantEntry ge) {
        return this.grantEntries.removeElement(ge);
    }

    public String getKeyStoreUrl() {
        try {
            if (this.keyStoreUrlString != null && this.keyStoreUrlString.length() != 0) {
                return this.expand(this.keyStoreUrlString).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException peee) {
            return null;
        }
        return null;
    }

    public void setKeyStoreUrl(String url) {
        this.keyStoreUrlString = url;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public Enumeration<GrantEntry> grantElements() {
        return this.grantEntries.elements();
    }

    public void write(Writer policy) {
        PrintWriter out = new PrintWriter(new BufferedWriter(policy));
        Enumeration<GrantEntry> enum_ = this.grantElements();
        out.println("/* AUTOMATICALLY GENERATED ON " + new Date() + "*/");
        out.println("/* DO NOT EDIT */");
        out.println();
        if (this.keyStoreUrlString != null) {
            this.writeKeyStoreEntry(out);
        }
        while (enum_.hasMoreElements()) {
            GrantEntry ge = enum_.nextElement();
            ge.write(out);
            out.println();
        }
        out.flush();
    }

    private void parseKeyStoreEntry() throws ParsingException, IOException {
        this.match("keystore");
        this.keyStoreUrlString = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw new ParsingException(this.st.lineno(), rb.getString("expected.keystore.type"));
        }
        this.keyStoreType = this.match("quoted string");
    }

    private void writeKeyStoreEntry(PrintWriter out) {
        out.print("keystore \"");
        out.print(this.keyStoreUrlString);
        out.print('\"');
        if (this.keyStoreType != null && this.keyStoreType.length() > 0) {
            out.print(", \"" + this.keyStoreType + "\"");
        }
        out.println(";");
        out.println();
    }

    private GrantEntry parseGrantEntry() throws ParsingException, IOException {
        GrantEntry e = new GrantEntry();
        LinkedList<PrincipalEntry> principals = null;
        boolean ignoreEntry = false;
        this.match("grant");
        while (!this.peek("{")) {
            if (this.peekAndMatch("Codebase")) {
                e.codeBase = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("SignedBy")) {
                e.signedBy = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("Principal")) {
                String principalName;
                String principalClass;
                if (principals == null) {
                    principals = new LinkedList<PrincipalEntry>();
                }
                if (this.peek("*")) {
                    this.match("*");
                    principalClass = "WILDCARD_PRINCIPAL_CLASS";
                } else {
                    principalClass = this.match("principal type");
                }
                if (this.peek("*")) {
                    this.match("*");
                    principalName = "WILDCARD_PRINCIPAL_NAME";
                } else {
                    principalName = this.match("quoted string");
                }
                if (principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
                    if (debug != null) {
                        debug.println("disallowing principal that has WILDCARD class but no WILDCARD name");
                    }
                    throw new ParsingException(this.st.lineno(), rb.getString("can.not.specify.Principal.with.a.wildcard.class.without.a.wildcard.name"));
                }
                try {
                    principalName = this.expand(principalName);
                    principals.add(new PrincipalEntry(principalClass, principalName));
                }
                catch (PropertyExpander.ExpandException peee) {
                    if (debug != null) {
                        debug.println("principal name expansion failed: " + principalName);
                    }
                    ignoreEntry = true;
                }
                this.peekAndMatch(",");
                continue;
            }
            throw new ParsingException(this.st.lineno(), rb.getString("expected.codeBase.or.SignedBy"));
        }
        if (principals == null) {
            throw new ParsingException(this.st.lineno(), rb.getString("only.Principal.based.grant.entries.permitted"));
        }
        e.principals = principals;
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                try {
                    PermissionEntry pe = this.parsePermissionEntry();
                    e.add(pe);
                }
                catch (PropertyExpander.ExpandException peee) {
                    this.skipEntry();
                }
                this.match(";");
                continue;
            }
            throw new ParsingException(this.st.lineno(), rb.getString("expected.permission.entry"));
        }
        this.match("}");
        try {
            if (e.codeBase != null) {
                e.codeBase = this.expand(e.codeBase).replace(File.separatorChar, '/');
            }
            e.signedBy = this.expand(e.signedBy);
        }
        catch (PropertyExpander.ExpandException peee) {
            return null;
        }
        return ignoreEntry ? null : e;
    }

    private PermissionEntry parsePermissionEntry() throws ParsingException, IOException, PropertyExpander.ExpandException {
        PermissionEntry e = new PermissionEntry();
        this.match("Permission");
        e.permission = this.match("permission type");
        if (this.peek("\"")) {
            e.name = this.expand(this.match("quoted string"));
        }
        if (!this.peek(",")) {
            return e;
        }
        this.match(",");
        if (this.peek("\"")) {
            e.action = this.expand(this.match("quoted string"));
            if (!this.peek(",")) {
                return e;
            }
            this.match(",");
        }
        if (this.peekAndMatch("SignedBy")) {
            e.signedBy = this.expand(this.match("quoted string"));
        }
        return e;
    }

    private boolean peekAndMatch(String expect) throws ParsingException, IOException {
        if (this.peek(expect)) {
            this.match(expect);
            return true;
        }
        return false;
    }

    private boolean peek(String expect) {
        boolean found = false;
        switch (this.lookahead) {
            case -3: {
                if (!expect.equalsIgnoreCase(this.st.sval)) break;
                found = true;
                break;
            }
            case 44: {
                if (!expect.equalsIgnoreCase(",")) break;
                found = true;
                break;
            }
            case 123: {
                if (!expect.equalsIgnoreCase("{")) break;
                found = true;
                break;
            }
            case 125: {
                if (!expect.equalsIgnoreCase("}")) break;
                found = true;
                break;
            }
            case 34: {
                if (!expect.equalsIgnoreCase("\"")) break;
                found = true;
                break;
            }
            case 42: {
                if (!expect.equalsIgnoreCase("*")) break;
                found = true;
                break;
            }
        }
        return found;
    }

    private String match(String expect) throws ParsingException, IOException {
        String value = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParsingException(this.st.lineno(), expect, rb.getString("number.") + String.valueOf(this.st.nval));
            }
            case -1: {
                MessageFormat form = new MessageFormat(rb.getString("expected.expect.read.end.of.file."));
                Object[] source = new Object[]{expect};
                throw new ParsingException(form.format(source));
            }
            case -3: {
                if (expect.equalsIgnoreCase(this.st.sval)) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("permission type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("principal type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, this.st.sval);
            }
            case 34: {
                if (expect.equalsIgnoreCase("quoted string")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("permission type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("principal type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, this.st.sval);
            }
            case 44: {
                if (expect.equalsIgnoreCase(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, ",");
            }
            case 123: {
                if (expect.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, "{");
            }
            case 125: {
                if (expect.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, "}");
            }
            case 59: {
                if (expect.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, ";");
            }
            case 42: {
                if (expect.equalsIgnoreCase("*")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, "*");
            }
            default: {
                throw new ParsingException(this.st.lineno(), expect, new String(new char[]{(char)this.lookahead}));
            }
        }
        return value;
    }

    private void skipEntry() throws ParsingException, IOException {
        while (this.lookahead != 59) {
            switch (this.lookahead) {
                case -2: {
                    throw new ParsingException(this.st.lineno(), ";", rb.getString("number.") + String.valueOf(this.st.nval));
                }
                case -1: {
                    throw new ParsingException(rb.getString("expected.read.end.of.file"));
                }
            }
            this.lookahead = this.st.nextToken();
        }
    }

    public static void main(String[] arg) throws Exception {
        PolicyParser pp = new PolicyParser(true);
        pp.read(new FileReader(arg[0]));
        FileWriter fr = new FileWriter(arg[1]);
        pp.write(fr);
        fr.close();
    }

    static class ParsingException
    extends GeneralSecurityException {
        private static final long serialVersionUID = 8240970523155877400L;

        public ParsingException(String msg) {
            super(msg);
        }

        public ParsingException(int line, String msg) {
            super(rb.getString("line.") + line + rb.getString("COLON") + msg);
        }

        public ParsingException(int line, String expect, String actual) {
            super(rb.getString("line.") + line + rb.getString(".expected.") + expect + rb.getString(".found.") + actual + rb.getString("QUOTE"));
        }
    }

    static class PermissionEntry {
        public String permission;
        public String name;
        public String action;
        public String signedBy;

        public PermissionEntry() {
        }

        public PermissionEntry(String permission, String name, String action) {
            this.permission = permission;
            this.name = name;
            this.action = action;
        }

        public int hashCode() {
            int retval = this.permission.hashCode();
            if (this.name != null) {
                retval ^= this.name.hashCode();
            }
            if (this.action != null) {
                retval ^= this.action.hashCode();
            }
            return retval;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry that = (PermissionEntry)obj;
            if (this.permission == null ? that.permission != null : !this.permission.equals(that.permission)) {
                return false;
            }
            if (this.name == null ? that.name != null : !this.name.equals(that.name)) {
                return false;
            }
            if (this.action == null ? that.action != null : !this.action.equals(that.action)) {
                return false;
            }
            return !(this.signedBy == null ? that.signedBy != null : !this.signedBy.equals(that.signedBy));
        }

        public void write(PrintWriter out) {
            out.print("permission ");
            out.print(this.permission);
            if (this.name != null) {
                out.print(" \"");
                if (this.name.indexOf("\"") != -1) {
                    int numQuotes = 0;
                    char[] chars = this.name.toCharArray();
                    for (int i = 0; i < chars.length; ++i) {
                        if (chars[i] != '\"') continue;
                        ++numQuotes;
                    }
                    char[] newChars = new char[chars.length + numQuotes];
                    int j = 0;
                    for (int i = 0; i < chars.length; ++i) {
                        if (chars[i] != '\"') {
                            newChars[j++] = chars[i];
                            continue;
                        }
                        newChars[j++] = 92;
                        newChars[j++] = chars[i];
                    }
                    this.name = new String(newChars);
                }
                out.print(this.name);
                out.print('\"');
            }
            if (this.action != null) {
                out.print(", \"");
                out.print(this.action);
                out.print('\"');
            }
            if (this.signedBy != null) {
                out.print(", signedBy \"");
                out.print(this.signedBy);
                out.print('\"');
            }
            out.println(";");
        }
    }

    static class PrincipalEntry {
        static final String WILDCARD_CLASS = "WILDCARD_PRINCIPAL_CLASS";
        static final String WILDCARD_NAME = "WILDCARD_PRINCIPAL_NAME";
        String principalClass;
        String principalName;

        public PrincipalEntry(String principalClass, String principalName) {
            if (principalClass == null || principalName == null) {
                throw new NullPointerException("null principalClass or principalName");
            }
            this.principalClass = principalClass;
            this.principalName = principalName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrincipalEntry)) {
                return false;
            }
            PrincipalEntry that = (PrincipalEntry)obj;
            return this.principalClass.equals(that.principalClass) && this.principalName.equals(that.principalName);
        }

        public int hashCode() {
            return this.principalClass.hashCode();
        }
    }

    static class GrantEntry {
        public String signedBy;
        public String codeBase;
        public LinkedList<PrincipalEntry> principals;
        public Vector<PermissionEntry> permissionEntries;

        public GrantEntry() {
            this.permissionEntries = new Vector();
        }

        public GrantEntry(String signedBy, String codeBase) {
            this.codeBase = codeBase;
            this.signedBy = signedBy;
            this.permissionEntries = new Vector();
        }

        public void add(PermissionEntry pe) {
            this.permissionEntries.addElement(pe);
        }

        public boolean remove(PermissionEntry pe) {
            return this.permissionEntries.removeElement(pe);
        }

        public boolean contains(PermissionEntry pe) {
            return this.permissionEntries.contains(pe);
        }

        public Enumeration<PermissionEntry> permissionElements() {
            return this.permissionEntries.elements();
        }

        public void write(PrintWriter out) {
            Object pe;
            out.print("grant");
            if (this.signedBy != null) {
                out.print(" signedBy \"");
                out.print(this.signedBy);
                out.print('\"');
                if (this.codeBase != null) {
                    out.print(", ");
                }
            }
            if (this.codeBase != null) {
                out.print(" codeBase \"");
                out.print(this.codeBase);
                out.print('\"');
                if (this.principals != null && this.principals.size() > 0) {
                    out.print(",\n");
                }
            }
            if (this.principals != null && this.principals.size() > 0) {
                ListIterator pli = this.principals.listIterator();
                while (pli.hasNext()) {
                    out.print("\tPrincipal ");
                    pe = (PrincipalEntry)pli.next();
                    out.print(((PrincipalEntry)pe).principalClass + " \"" + ((PrincipalEntry)pe).principalName + "\"");
                    if (!pli.hasNext()) continue;
                    out.print(",\n");
                }
            }
            out.println(" {");
            Enumeration<PermissionEntry> enum_ = this.permissionEntries.elements();
            while (enum_.hasMoreElements()) {
                pe = enum_.nextElement();
                out.write("  ");
                ((PermissionEntry)pe).write(out);
            }
            out.println("};");
        }
    }
}

