/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import sun.misc.HexDumpEncoder;
import sun.security.provider.certpath.CertId;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;

class OCSPRequest {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = Debug.isOn("ocsp");
    private final List<CertId> certIds;

    OCSPRequest(CertId certId) {
        this.certIds = Collections.singletonList(certId);
    }

    OCSPRequest(List<CertId> certIds) {
        this.certIds = certIds;
    }

    byte[] encodeBytes() throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream requestsOut = new DerOutputStream();
        for (CertId certId : this.certIds) {
            DerOutputStream certIdOut = new DerOutputStream();
            certId.encode(certIdOut);
            requestsOut.write((byte)48, certIdOut);
        }
        tmp.write((byte)48, requestsOut);
        DerOutputStream tbsRequest = new DerOutputStream();
        tbsRequest.write((byte)48, tmp);
        DerOutputStream ocspRequest = new DerOutputStream();
        ocspRequest.write((byte)48, tbsRequest);
        byte[] bytes = ocspRequest.toByteArray();
        if (dump) {
            HexDumpEncoder hexEnc = new HexDumpEncoder();
            debug.println("\nOCSPRequest bytes... ");
            debug.println(hexEnc.encode(bytes) + "\n");
        }
        return bytes;
    }

    List<CertId> getCertIds() {
        return this.certIds;
    }
}

