/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    protected String attrID;
    protected transient Vector<Object> values;
    protected boolean ordered = false;
    private static final long serialVersionUID = 6743528196119291326L;

    @Override
    public Object clone() {
        BasicAttribute attr;
        try {
            attr = (BasicAttribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            attr = new BasicAttribute(this.attrID, this.ordered);
        }
        attr.values = (Vector)this.values.clone();
        return attr;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Attribute) {
            int len;
            Attribute target = (Attribute)obj;
            if (this.isOrdered() != target.isOrdered()) {
                return false;
            }
            if (this.attrID.equals(target.getID()) && (len = this.size()) == target.size()) {
                try {
                    if (this.isOrdered()) {
                        for (int i = 0; i < len; ++i) {
                            if (BasicAttribute.valueEquals(this.get(i), target.get(i))) continue;
                            return false;
                        }
                    } else {
                        NamingEnumeration<?> theirs = target.getAll();
                        while (theirs.hasMoreElements()) {
                            if (this.find(theirs.nextElement()) >= 0) continue;
                            return false;
                        }
                    }
                }
                catch (NamingException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.attrID.hashCode();
        int num = this.values.size();
        for (int i = 0; i < num; ++i) {
            Object val = this.values.elementAt(i);
            if (val == null) continue;
            if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                for (int j = 0; j < len; ++j) {
                    Object it = Array.get(val, j);
                    if (it == null) continue;
                    hash += it.hashCode();
                }
                continue;
            }
            hash += val.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer(this.attrID + ": ");
        if (this.values.size() == 0) {
            answer.append("No values");
        } else {
            boolean start = true;
            Enumeration<Object> e = this.values.elements();
            while (e.hasMoreElements()) {
                if (!start) {
                    answer.append(", ");
                }
                answer.append(e.nextElement());
                start = false;
            }
        }
        return answer.toString();
    }

    public BasicAttribute(String id) {
        this(id, false);
    }

    public BasicAttribute(String id, Object value) {
        this(id, value, false);
    }

    public BasicAttribute(String id, boolean ordered) {
        this.attrID = id;
        this.values = new Vector();
        this.ordered = ordered;
    }

    public BasicAttribute(String id, Object value, boolean ordered) {
        this(id, ordered);
        this.values.addElement(value);
    }

    @Override
    public NamingEnumeration<?> getAll() throws NamingException {
        return new ValuesEnumImpl();
    }

    @Override
    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("Attribute " + this.getID() + " has no value");
        }
        return this.values.elementAt(0);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String getID() {
        return this.attrID;
    }

    @Override
    public boolean contains(Object attrVal) {
        return this.find(attrVal) >= 0;
    }

    private int find(Object target) {
        if (target == null) {
            int ct = this.values.size();
            for (int i = 0; i < ct; ++i) {
                if (this.values.elementAt(i) != null) continue;
                return i;
            }
        } else {
            Class<?> cl = target.getClass();
            if (cl.isArray()) {
                int ct = this.values.size();
                for (int i = 0; i < ct; ++i) {
                    Object it = this.values.elementAt(i);
                    if (it == null || cl != it.getClass() || !BasicAttribute.arrayEquals(target, it)) continue;
                    return i;
                }
            } else {
                return this.values.indexOf(target, 0);
            }
        }
        return -1;
    }

    private static boolean valueEquals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        if (obj1.getClass().isArray() && obj2.getClass().isArray()) {
            return BasicAttribute.arrayEquals(obj1, obj2);
        }
        return obj1.equals(obj2);
    }

    private static boolean arrayEquals(Object a1, Object a2) {
        int len = Array.getLength(a1);
        if (len != Array.getLength(a2)) {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            Object i1 = Array.get(a1, j);
            Object i2 = Array.get(a2, j);
            if (!(i1 == null || i2 == null ? i1 != i2 : !i1.equals(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Object attrVal) {
        if (this.isOrdered() || this.find(attrVal) < 0) {
            this.values.addElement(attrVal);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object attrval) {
        int i = this.find(attrval);
        if (i >= 0) {
            this.values.removeElementAt(i);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.values.setSize(0);
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Object get(int ix) throws NamingException {
        return this.values.elementAt(ix);
    }

    @Override
    public Object remove(int ix) {
        Object answer = this.values.elementAt(ix);
        this.values.removeElementAt(ix);
        return answer;
    }

    @Override
    public void add(int ix, Object attrVal) {
        if (!this.isOrdered() && this.contains(attrVal)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        this.values.insertElementAt(attrVal, ix);
    }

    @Override
    public Object set(int ix, Object attrVal) {
        if (!this.isOrdered() && this.contains(attrVal)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        Object answer = this.values.elementAt(ix);
        this.values.setElementAt(attrVal, ix);
        return answer;
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute syntax");
    }

    @Override
    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute definition");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            s.writeObject(this.values.elementAt(i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int n = s.readInt();
        this.values = new Vector(n);
        while (--n >= 0) {
            this.values.addElement(s.readObject());
        }
    }

    class ValuesEnumImpl
    implements NamingEnumeration<Object> {
        Enumeration<Object> list;

        ValuesEnumImpl() {
            this.list = BasicAttribute.this.values.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.list.hasMoreElements();
        }

        @Override
        public Object nextElement() {
            return this.list.nextElement();
        }

        @Override
        public Object next() throws NamingException {
            return this.list.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.list.hasMoreElements();
        }

        @Override
        public void close() throws NamingException {
            this.list = null;
        }
    }
}

