/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ActivateLicenseResponse;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class ActivateLicense
extends BaseCmd {
    private static final String LICENSE_ID_DESC = "The license to activate capacity against.";
    private static final String CAPACITY_DESC = "The amount of capacity to activate.";

    public ActivateLicense(String[] args) {
        super("ec2actlic", "ec2-activate-license");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ActivateLicense.createOptionWithArgs("c", "capacity", CAPACITY_DESC, "CAPACITY"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "LICENSE -c CAPACITY";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Activate capacity against a license");
        System.out.println("     The LICENSE parameter is the id of the license to activate.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("capacity");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        int capacity;
        this.assertNonOptionSet("LICENSE");
        this.warnIfTooManyNonOptions();
        if (!this.isOptionSet("capacity")) {
            throw new MissingArgument("capacity");
        }
        String licenseId = this.getNonOptions()[0];
        try {
            capacity = Integer.parseInt(this.getOptionValue("capacity"));
        }
        catch (NumberFormatException e) {
            throw new InvalidArgument("capacity", this.getOptionValue("capacity"));
        }
        RequestResultPair rsp = jec2.activateLicense(licenseId, capacity);
        if (rsp.getResponse() != null) {
            out.output(System.out, (ActivateLicenseResponse)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new ActivateLicense(args).invoke();
    }
}

