/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;

public class FtpDirEntry {
    private final String name;
    private String user = null;
    private String group = null;
    private long size = -1L;
    private Date created = null;
    private Date lastModified = null;
    private Type type = Type.FILE;
    private boolean[][] permissions = null;
    private HashMap<String, String> facts = new HashMap();

    private FtpDirEntry() {
        this.name = null;
    }

    public FtpDirEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public FtpDirEntry setUser(String user) {
        this.user = user;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public FtpDirEntry setGroup(String group) {
        this.group = group;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public FtpDirEntry setSize(long size) {
        this.size = size;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public FtpDirEntry setType(Type type) {
        this.type = type;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public FtpDirEntry setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public boolean canRead(Permission p) {
        if (this.permissions != null) {
            return this.permissions[p.value][0];
        }
        return false;
    }

    public boolean canWrite(Permission p) {
        if (this.permissions != null) {
            return this.permissions[p.value][1];
        }
        return false;
    }

    public boolean canExexcute(Permission p) {
        if (this.permissions != null) {
            return this.permissions[p.value][2];
        }
        return false;
    }

    public FtpDirEntry setPermissions(boolean[][] permissions) {
        this.permissions = permissions;
        return this;
    }

    public FtpDirEntry addFact(String fact, String value) {
        this.facts.put(fact.toLowerCase(), value);
        return this;
    }

    public String getFact(String fact) {
        return this.facts.get(fact.toLowerCase());
    }

    public Date getCreated() {
        return this.created;
    }

    public FtpDirEntry setCreated(Date created) {
        this.created = created;
        return this;
    }

    public String toString() {
        if (this.lastModified == null) {
            return this.name + " [" + (Object)((Object)this.type) + "] (" + this.user + " / " + this.group + ") " + this.size;
        }
        return this.name + " [" + (Object)((Object)this.type) + "] (" + this.user + " / " + this.group + ") {" + this.size + "} " + DateFormat.getDateInstance().format(this.lastModified);
    }

    public static enum Permission {
        USER(0),
        GROUP(1),
        OTHERS(2);

        int value;

        private Permission(int v) {
            this.value = v;
        }
    }

    public static enum Type {
        FILE,
        DIR,
        PDIR,
        CDIR,
        LINK;

    }
}

