/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import sun.net.httpserver.ServerConfig;
import sun.net.httpserver.ServerImpl;

class Request {
    static final int BUF_LEN = 2048;
    static final byte CR = 13;
    static final byte LF = 10;
    private String startLine;
    private SocketChannel chan;
    private InputStream is;
    private OutputStream os;
    char[] buf = new char[2048];
    int pos;
    StringBuffer lineBuf;
    Headers hdrs = null;

    Request(InputStream rawInputStream, OutputStream rawout) throws IOException {
        this.is = rawInputStream;
        this.os = rawout;
        do {
            this.startLine = this.readLine();
            if (this.startLine != null) continue;
            return;
        } while (this.startLine != null && this.startLine.equals(""));
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    public String readLine() throws IOException {
        boolean gotCR = false;
        boolean gotLF = false;
        this.pos = 0;
        this.lineBuf = new StringBuffer();
        while (!gotLF) {
            int c = this.is.read();
            if (c == -1) {
                return null;
            }
            if (gotCR) {
                if (c == 10) {
                    gotLF = true;
                    continue;
                }
                gotCR = false;
                this.consume(13);
                this.consume(c);
                continue;
            }
            if (c == 13) {
                gotCR = true;
                continue;
            }
            this.consume(c);
        }
        this.lineBuf.append(this.buf, 0, this.pos);
        return new String(this.lineBuf);
    }

    private void consume(int c) {
        if (this.pos == 2048) {
            this.lineBuf.append(this.buf);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)c;
    }

    public String requestLine() {
        return this.startLine;
    }

    /*
     * Enabled aggressive block sorting
     */
    Headers headers() throws IOException {
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        char[] s = new char[10];
        int len = 0;
        int firstc = this.is.read();
        if (firstc == 13 || firstc == 10) {
            int c = this.is.read();
            if (c == 13 || c == 10) {
                return this.hdrs;
            }
            s[0] = (char)firstc;
            len = 1;
            firstc = c;
        }
        while (true) {
            String k;
            int keyend;
            block23: {
                int c;
                boolean inKey;
                if (firstc != 10 && firstc != 13 && firstc >= 0) {
                    keyend = -1;
                    inKey = firstc > 32;
                    s[len++] = (char)firstc;
                } else {
                    return this.hdrs;
                }
                while ((c = this.is.read()) >= 0) {
                    switch (c) {
                        case 58: {
                            if (inKey && len > 0) {
                                keyend = len;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            c = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstc = this.is.read();
                            if (c == 13 && firstc == 10 && (firstc = this.is.read()) == 13) {
                                firstc = this.is.read();
                            }
                            if (firstc == 10 || firstc == 13 || firstc > 32) break block23;
                            c = 32;
                        }
                    }
                    if (len >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, len);
                        s = ns;
                    }
                    s[len++] = (char)c;
                }
                firstc = -1;
            }
            while (len > 0 && s[len - 1] <= ' ') {
                --len;
            }
            if (keyend <= 0) {
                k = null;
                keyend = 0;
            } else {
                k = String.copyValueOf(s, 0, keyend);
                if (keyend < len && s[keyend] == ':') {
                    ++keyend;
                }
                while (keyend < len && s[keyend] <= ' ') {
                    ++keyend;
                }
            }
            String v = keyend >= len ? new String() : String.copyValueOf(s, keyend, len - keyend);
            if (this.hdrs.size() >= ServerConfig.getMaxReqHeaders()) {
                throw new IOException("Maximum number of request headers (sun.net.httpserver.maxReqHeaders) exceeded, " + ServerConfig.getMaxReqHeaders() + ".");
            }
            this.hdrs.add(k, v);
            len = 0;
        }
    }

    static class WriteStream
    extends OutputStream {
        SocketChannel channel;
        ByteBuffer buf;
        SelectionKey key;
        boolean closed;
        byte[] one;
        ServerImpl server;

        public WriteStream(ServerImpl server, SocketChannel channel) throws IOException {
            this.channel = channel;
            this.server = server;
            assert (channel.isBlocking());
            this.closed = false;
            this.one = new byte[1];
            this.buf = ByteBuffer.allocate(4096);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.one[0] = (byte)b;
            this.write(this.one, 0, 1);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            int n;
            int l = len;
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            int cap = this.buf.capacity();
            if (cap < len) {
                int diff = len - cap;
                this.buf = ByteBuffer.allocate(2 * (cap + diff));
            }
            this.buf.clear();
            this.buf.put(b, off, len);
            this.buf.flip();
            while ((n = this.channel.write(this.buf)) < l) {
                if ((l -= n) != 0) continue;
                return;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.closed = true;
        }
    }

    static class ReadStream
    extends InputStream {
        SocketChannel channel;
        ByteBuffer chanbuf;
        byte[] one;
        private boolean closed = false;
        private boolean eof = false;
        ByteBuffer markBuf;
        boolean marked;
        boolean reset;
        int readlimit;
        static long readTimeout;
        ServerImpl server;
        static final int BUFSIZE = 8192;

        public ReadStream(ServerImpl server, SocketChannel chan) throws IOException {
            this.channel = chan;
            this.server = server;
            this.chanbuf = ByteBuffer.allocate(8192);
            this.chanbuf.clear();
            this.one = new byte[1];
            this.reset = false;
            this.marked = false;
            this.closed = false;
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read() throws IOException {
            int result = this.read(this.one, 0, 1);
            if (result == 1) {
                return this.one[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] b, int off, int srclen) throws IOException {
            int willreturn;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.eof) {
                return -1;
            }
            assert (this.channel.isBlocking());
            if (off < 0 || srclen < 0 || srclen > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (this.reset) {
                int canreturn = this.markBuf.remaining();
                willreturn = canreturn > srclen ? srclen : canreturn;
                this.markBuf.get(b, off, willreturn);
                if (canreturn == willreturn) {
                    this.reset = false;
                }
            } else {
                this.chanbuf.clear();
                if (srclen < 8192) {
                    this.chanbuf.limit(srclen);
                }
                while ((willreturn = this.channel.read(this.chanbuf)) == 0) {
                }
                if (willreturn == -1) {
                    this.eof = true;
                    return -1;
                }
                this.chanbuf.flip();
                this.chanbuf.get(b, off, willreturn);
                if (this.marked) {
                    try {
                        this.markBuf.put(b, off, willreturn);
                    }
                    catch (BufferOverflowException e) {
                        this.marked = false;
                    }
                }
            }
            return willreturn;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            if (this.reset) {
                return this.markBuf.remaining();
            }
            return this.chanbuf.remaining();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.closed = true;
        }

        @Override
        public synchronized void mark(int readlimit) {
            if (this.closed) {
                return;
            }
            this.readlimit = readlimit;
            this.markBuf = ByteBuffer.allocate(readlimit);
            this.marked = true;
            this.reset = false;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.marked) {
                throw new IOException("Stream not marked");
            }
            this.marked = false;
            this.reset = true;
            this.markBuf.flip();
        }
    }
}

