/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.IOException;
import java.util.Vector;
import sun.net.NetworkClient;

public class TransferProtocolClient
extends NetworkClient {
    static final boolean debug = false;
    protected Vector<String> serverResponse = new Vector(1);
    protected int lastReplyCode;

    public int readServerResponse() throws IOException {
        int code;
        StringBuffer replyBuf = new StringBuffer(32);
        int continuingCode = -1;
        this.serverResponse.setSize(0);
        while (true) {
            int c;
            if ((c = this.serverInput.read()) != -1) {
                if (c == 13 && (c = this.serverInput.read()) != 10) {
                    replyBuf.append('\r');
                }
                replyBuf.append((char)c);
                if (c != 10) continue;
            }
            String response = replyBuf.toString();
            replyBuf.setLength(0);
            if (response.length() == 0) {
                code = -1;
            } else {
                try {
                    code = Integer.parseInt(response.substring(0, 3));
                }
                catch (NumberFormatException e) {
                    code = -1;
                }
                catch (StringIndexOutOfBoundsException e) {
                    continue;
                }
            }
            this.serverResponse.addElement(response);
            if (continuingCode != -1) {
                if (code != continuingCode || response.length() >= 4 && response.charAt(3) == '-') continue;
                continuingCode = -1;
                break;
            }
            if (response.length() < 4 || response.charAt(3) != '-') break;
            continuingCode = code;
        }
        this.lastReplyCode = code;
        return this.lastReplyCode;
    }

    public void sendServer(String cmd) {
        this.serverOutput.print(cmd);
    }

    public String getResponseString() {
        return this.serverResponse.elementAt(0);
    }

    public Vector<String> getResponseStrings() {
        return this.serverResponse;
    }

    public TransferProtocolClient(String host, int port) throws IOException {
        super(host, port);
    }

    public TransferProtocolClient() {
    }
}

