/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleDataMetaInfo;
import sun.util.resources.OpenListResourceBundle;

public class LocaleData {
    private static final String localeDataJarName = "localedata.jar";

    public static Locale[] getAvailableLocales() {
        return (Locale[])AvailableLocales.localeList.clone();
    }

    public static ResourceBundle getCalendarData(Locale locale) {
        return LocaleData.getBundle("sun.util.resources.CalendarData", locale);
    }

    public static OpenListResourceBundle getCurrencyNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.CurrencyNames", locale);
    }

    public static OpenListResourceBundle getLocaleNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.LocaleNames", locale);
    }

    public static OpenListResourceBundle getTimeZoneNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.TimeZoneNames", locale);
    }

    public static ResourceBundle getCollationData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.CollationData", locale);
    }

    public static ResourceBundle getDateFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    public static ResourceBundle getNumberFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    private static ResourceBundle getBundle(final String baseName, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                return ResourceBundle.getBundle(baseName, locale, LocaleDataResourceBundleControl.getRBControlInstance());
            }
        });
    }

    private static boolean isNonEuroLangSupported() {
        String sep = File.separator;
        String localeDataJar = AccessController.doPrivileged(new GetPropertyAction("java.home")) + sep + "lib" + sep + "ext" + sep + localeDataJarName;
        final File f = new File(localeDataJar);
        boolean isNonEuroResJarExist = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.exists();
            }
        });
        return isNonEuroResJarExist;
    }

    private static Locale[] createLocaleList() {
        String supportedLocaleString = LocaleDataMetaInfo.getSupportedLocaleString("sun.text.resources.FormatData");
        if (supportedLocaleString.length() == 0) {
            return null;
        }
        int barIndex = supportedLocaleString.indexOf("|");
        StringTokenizer localeStringTokenizer = null;
        localeStringTokenizer = LocaleData.isNonEuroLangSupported() ? new StringTokenizer(supportedLocaleString.substring(0, barIndex) + supportedLocaleString.substring(barIndex + 1)) : new StringTokenizer(supportedLocaleString.substring(0, barIndex));
        Locale[] locales = new Locale[localeStringTokenizer.countTokens()];
        for (int i = 0; i < locales.length; ++i) {
            String currentToken = localeStringTokenizer.nextToken().replace('_', '-');
            if (currentToken.equals("ja-JP-JP")) {
                currentToken = "ja-JP-u-ca-japanese-x-lvariant-JP";
            } else if (currentToken.equals("th-TH-TH")) {
                currentToken = "th-TH-u-nu-thai-x-lvariant-TH";
            } else if (currentToken.equals("no-NO-NY")) {
                currentToken = "no-NO-x-lvariant-NY";
            }
            locales[i] = Locale.forLanguageTag(currentToken);
        }
        return locales;
    }

    static /* synthetic */ Locale[] access$000() {
        return LocaleData.createLocaleList();
    }

    static class LocaleDataResourceBundleControl
    extends ResourceBundle.Control {
        private static LocaleDataResourceBundleControl rbControlInstance = new LocaleDataResourceBundleControl();

        LocaleDataResourceBundleControl() {
        }

        public static LocaleDataResourceBundleControl getRBControlInstance() {
            return rbControlInstance;
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> candidates = super.getCandidateLocales(baseName, locale);
            String localeString = LocaleDataMetaInfo.getSupportedLocaleString(baseName);
            if (localeString.length() == 0) {
                return candidates;
            }
            Iterator<Locale> l = candidates.iterator();
            while (l.hasNext()) {
                Locale loc = l.next();
                String lstr = null;
                if (loc.getScript().length() > 0) {
                    lstr = loc.toLanguageTag().replace('-', '_');
                } else {
                    lstr = loc.toString();
                    int idx = lstr.indexOf("_#");
                    if (idx >= 0) {
                        lstr = lstr.substring(0, idx);
                    }
                }
                if (lstr.length() == 0 || localeString.indexOf(" " + lstr + " ") != -1) continue;
                l.remove();
            }
            return candidates;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class AvailableLocales {
        static final Locale[] localeList = LocaleData.access$000();

        private AvailableLocales() {
        }
    }
}

