/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;

final class RandomCookie {
    byte[] random_bytes;

    RandomCookie(SecureRandom generator) {
        long temp = System.currentTimeMillis() / 1000L;
        int gmt_unix_time = temp < Integer.MAX_VALUE ? (int)temp : Integer.MAX_VALUE;
        this.random_bytes = new byte[32];
        generator.nextBytes(this.random_bytes);
        this.random_bytes[0] = (byte)(gmt_unix_time >> 24);
        this.random_bytes[1] = (byte)(gmt_unix_time >> 16);
        this.random_bytes[2] = (byte)(gmt_unix_time >> 8);
        this.random_bytes[3] = (byte)gmt_unix_time;
    }

    RandomCookie(HandshakeInStream m) throws IOException {
        this.random_bytes = new byte[32];
        m.read(this.random_bytes, 0, 32);
    }

    void send(HandshakeOutStream out) throws IOException {
        out.write(this.random_bytes, 0, 32);
    }

    void print(PrintStream s) {
        int gmt_unix_time = this.random_bytes[0] << 24;
        gmt_unix_time += this.random_bytes[1] << 16;
        gmt_unix_time += this.random_bytes[2] << 8;
        s.print("GMT: " + (gmt_unix_time += this.random_bytes[3]) + " ");
        s.print("bytes = { ");
        for (int i = 4; i < 32; ++i) {
            if (i != 4) {
                s.print(", ");
            }
            s.print(this.random_bytes[i] & 0xFF);
        }
        s.println(" }");
    }
}

