/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.List;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;
import sun.security.jca.ServiceId;

public class GetInstance {
    private GetInstance() {
    }

    public static Provider.Service getService(String type, String algorithm) throws NoSuchAlgorithmException {
        ProviderList list = Providers.getProviderList();
        Provider.Service s = list.getService(type, algorithm);
        if (s == null) {
            throw new NoSuchAlgorithmException(algorithm + " " + type + " not available");
        }
        return s;
    }

    public static Provider.Service getService(String type, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider p = Providers.getProviderList().getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("no such provider: " + provider);
        }
        Provider.Service s = p.getService(type, algorithm);
        if (s == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + algorithm + " for provider " + provider);
        }
        return s;
    }

    public static Provider.Service getService(String type, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider.Service s = provider.getService(type, algorithm);
        if (s == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + algorithm + " for provider " + provider.getName());
        }
        return s;
    }

    public static List<Provider.Service> getServices(String type, String algorithm) {
        ProviderList list = Providers.getProviderList();
        return list.getServices(type, algorithm);
    }

    @Deprecated
    public static List<Provider.Service> getServices(String type, List<String> algorithms) {
        ProviderList list = Providers.getProviderList();
        return list.getServices(type, algorithms);
    }

    public static List<Provider.Service> getServices(List<ServiceId> ids) {
        ProviderList list = Providers.getProviderList();
        return list.getServices(ids);
    }

    public static Instance getInstance(String type, Class<?> clazz, String algorithm) throws NoSuchAlgorithmException {
        ProviderList list = Providers.getProviderList();
        Provider.Service firstService = list.getService(type, algorithm);
        if (firstService == null) {
            throw new NoSuchAlgorithmException(algorithm + " " + type + " not available");
        }
        try {
            return GetInstance.getInstance(firstService, clazz);
        }
        catch (NoSuchAlgorithmException e) {
            NoSuchAlgorithmException failure = e;
            for (Provider.Service s : list.getServices(type, algorithm)) {
                if (s == firstService) continue;
                try {
                    return GetInstance.getInstance(s, clazz);
                }
                catch (NoSuchAlgorithmException e2) {
                    failure = e2;
                }
            }
            throw failure;
        }
    }

    public static Instance getInstance(String type, Class<?> clazz, String algorithm, Object param) throws NoSuchAlgorithmException {
        List<Provider.Service> services = GetInstance.getServices(type, algorithm);
        NoSuchAlgorithmException failure = null;
        for (Provider.Service s : services) {
            try {
                return GetInstance.getInstance(s, clazz, param);
            }
            catch (NoSuchAlgorithmException e) {
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
        throw new NoSuchAlgorithmException(algorithm + " " + type + " not available");
    }

    public static Instance getInstance(String type, Class<?> clazz, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return GetInstance.getInstance(GetInstance.getService(type, algorithm, provider), clazz);
    }

    public static Instance getInstance(String type, Class<?> clazz, String algorithm, Object param, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return GetInstance.getInstance(GetInstance.getService(type, algorithm, provider), clazz, param);
    }

    public static Instance getInstance(String type, Class<?> clazz, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(GetInstance.getService(type, algorithm, provider), clazz);
    }

    public static Instance getInstance(String type, Class<?> clazz, String algorithm, Object param, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(GetInstance.getService(type, algorithm, provider), clazz, param);
    }

    public static Instance getInstance(Provider.Service s, Class<?> clazz) throws NoSuchAlgorithmException {
        Object instance = s.newInstance(null);
        GetInstance.checkSuperClass(s, instance.getClass(), clazz);
        return new Instance(s.getProvider(), instance);
    }

    public static Instance getInstance(Provider.Service s, Class<?> clazz, Object param) throws NoSuchAlgorithmException {
        Object instance = s.newInstance(param);
        GetInstance.checkSuperClass(s, instance.getClass(), clazz);
        return new Instance(s.getProvider(), instance);
    }

    public static void checkSuperClass(Provider.Service s, Class<?> subClass, Class<?> superClass) throws NoSuchAlgorithmException {
        if (superClass == null) {
            return;
        }
        if (!superClass.isAssignableFrom(subClass)) {
            throw new NoSuchAlgorithmException("class configured for " + s.getType() + ": " + s.getClassName() + " not a " + s.getType());
        }
    }

    public static final class Instance {
        public final Provider provider;
        public final Object impl;

        private Instance(Provider provider, Object impl) {
            this.provider = provider;
            this.impl = impl;
        }

        public Object[] toArray() {
            return new Object[]{this.impl, this.provider};
        }
    }
}

